<?php

// ENCODING
if (!function_exists('mb_internal_encoding')) {
	exit('MBString library is missing! Tabulizer requires the MBString PHP extension in order to run properly. Please ask your system administrator to install it for you.');
}

mb_internal_encoding("UTF-8");
mb_regex_encoding("UTF-8");

// DIRECTORIES
if (!defined('DS')) define( 'DS', DIRECTORY_SEPARATOR );

define('RULES_DIR','templates/tabulizer/');
define('RULES_XML_DIR', RULES_DIR .'rules/');
define('RULES_CSS_DIR', RULES_DIR .'css/');
define('RULES_IMAGE_DIR', RULES_DIR .'images/');
define('RULES_UPLOAD_DIR','tmp/');
define('SHEET_UPLOAD_DIR','tmp/');

if (!defined('XML_FILE_EXT')) define('XML_FILE_EXT','.xml');

// STYLE INCLUDE PREFIX
define('TABULIZER_INCLUDE_STYLE_PREFIX','{tabulizer:style[%s]}');
define('TABULIZER_INCLUDE_STYLE_REGEX','/{tabulizer:style\[(.+)\]}/i');

// COLUMNS SEPARATORS
define('SEPARATOR_COMMA','cm');
define('SEPARATOR_SEMICOLON','sc');
define('SEPARATOR_SPACE','sp');
define('SEPARATOR_TAB','tb');
define('SEPARATOR_ASTERISK','as');
define('SEPARATOR_CARET','cr');

// COLUMN ENCLOSURES
define('ENCLOSURE_DOUBLE_QUOTES','dq');
define('ENCLOSURE_SINGLE_QUOTES','sq');
define('ENCLOSURE_NONE','none');

// ROWS SEPARATOS
define('SEPARATOR_NEWLLINE','[NEWLINEROW]');

// DATA TYPES
define('DATA_TYPE_SEPARATOR','^');
define('DATA_TYPE_UNDEFINED',0);
define('DATA_TYPE_TEXT',100);
define('DATA_TYPE_NUMERIC',300);
define('DATA_TYPE_CURRENCY',400);
define('DATA_TYPE_DATE',500);

// FORMAT
define('FORMAT_TEXT_UPPERCASE',110); // HELLO WORLD
define('FORMAT_TEXT_LOWERCASE',112); // hello world
define('FORMAT_TEXT_UCFIRST',113); // Hello world
define('FORMAT_TEXT_UCWORDS',114); // Hello World

define('FORMAT_DATE_DDMMYY_1',510); // 21-10-09
define('FORMAT_DATE_DDMMYY_2',511); // 21/10/09
define('FORMAT_DATE_MMDDYY_1',520); // 10-21-09
define('FORMAT_DATE_MMDDYY_2',521); // 10/21/09
define('FORMAT_DATE_DDMMYYYY_1',530); // 21-10-2009
define('FORMAT_DATE_DDMMYYYY_2',531); // 21/10/2009
define('FORMAT_DATE_DDMMYYYY_3',531); // 21/Oct/2009
define('FORMAT_DATE_MMDDYYYY_1',540); // 10-21-2009
define('FORMAT_DATE_MMDDYYYY_2',541); // 10/21/2009
define('FORMAT_DATE_MMDDYYYY_3',542); // Jan 1, 2009
define('FORMAT_DATE_dDDMMYYYY_1',550); // Monday, 21-Oct-2009
define('FORMAT_DATE_dDDMMYYYY_2',551); // Monday, 21/Oct/2009
define('FORMAT_DATE_dMMDDYYYY_1',560); // Monday, Oct 1, 2009
define('FORMAT_DATE_dMMDDYYYY_2',561); // Monday, 21-Oct-2009
define('FORMAT_DATE_dDDm_1',570); // Monday, 21 October
define('FORMAT_DATE_dmDD_1',575); // Monday, October 21

define('FORMAT_NUMERIC_SEPARATOR','*');
define('FORMAT_NUMERIC_DEC_POINT_COMMA',1);
define('FORMAT_NUMERIC_DEC_POINT_PERIOD',2);

define('FORMAT_CURRENCY_SEPARATOR','*');
define('FORMAT_CURRENCY_SYMBOL_ORDER_NONE',0);
define('FORMAT_CURRENCY_SYMBOL_ORDER_BEFORE',1);
define('FORMAT_CURRENCY_SYMBOL_ORDER_AFTER',2);

// REPLACEMENT
define('REPLACEMENT_SEPARATOR','^RWS^');

// CALCULATION
define('CALCULATION_NONE',0);
define('CALCULATION_ADD_ABOVE',110);
define('CALCULATION_ADD_BELOW',120);
define('CALCULATION_ADD_LEFT',130);
define('CALCULATION_ADD_RIGHT',140);
define('CALCULATION_MUL_ABOVE',210);
define('CALCULATION_MUL_BELOW',220);
define('CALCULATION_MUL_LEFT',230);
define('CALCULATION_MUL_RIGHT',240);
define('CALCULATION_AVG_ABOVE',310);
define('CALCULATION_AVG_BELOW',320);
define('CALCULATION_AVG_LEFT',330);
define('CALCULATION_AVG_RIGHT',340);
define('CALCULATION_MED_ABOVE',410);
define('CALCULATION_MED_BELOW',420);
define('CALCULATION_MED_LEFT',430);
define('CALCULATION_MED_RIGHT',440);
define('CALCULATION_MIN_ABOVE',510);
define('CALCULATION_MIN_BELOW',520);
define('CALCULATION_MIN_LEFT',530);
define('CALCULATION_MIN_RIGHT',540);
define('CALCULATION_MAX_ABOVE',610);
define('CALCULATION_MAX_BELOW',620);
define('CALCULATION_MAX_LEFT',630);
define('CALCULATION_MAX_RIGHT',640);

// FILE SIZES AND OTHER LIMITS
define('MAX_UPLOAD_SHEET_FILE_SIZE',1048576); // in bytes

// ERROR CODES
define('ERROR_CODE_PREFIX','ERROR');
define('ERROR_CODE_NO_ROWS','<7>');
define('ERROR_CODE_NUM_OF_COLUMN_DISCREPANCY','<13>');

// FUNCTIONS
function getNumericPoint($point) {
	switch ($point) {
		case FORMAT_NUMERIC_DEC_POINT_COMMA: return ',';
		case FORMAT_NUMERIC_DEC_POINT_PERIOD: return '.';
		default: return null;
	}
}

function increaseProcessingLimits($memory_size = 64, $execution_time = 120) {
	$size = intval(str_replace('M','',ini_get('memory_limit')));
	while ($size < $memory_size) {			
		$success = ini_set('memory_limit',$memory_size . 'M'); // in MB
		if (!$success) $memory_size = $memory_size / 2;
		else break;
	}
	$time = intval(ini_get('max_execution_time'));
	if ($time <= $execution_time) {
		ini_set('max_execution_time', $execution_time); // in seconds
	}
}




?>