<?php
/**
 * Insert HTML table editor button plugin for Joomla! 
 *   
 * @package HTML editor plugin for Joomla!
 * @author Dimitrios Mourloukos <info@alterora.gr> 
 * @GNU General Public License   
 */ 

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class plgButtonTabulizer extends JPlugin
{
	/**
	 * Constructor	 
	 */
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}
	
	public function onDisplay($name)
	{		
		$app = JFactory::getApplication();

		$doc		= JFactory::getDocument();
		$template	= $app->getTemplate();
				
		$tabulizer_directive_add_comments = 0;
		
		require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_tabulizer'.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'permissions.php');
		$perm = new TabulizerPermissions();				
		$no_use_permissions = ($perm->isAllowed('ruleset-use'))?0:1;
		$no_use_permissions_warning_msg = addslashes(JText::_('PLG_TABULIZER_RULESET_USE_PERMISSION_INVALID'));
		
		$popup_url = JURI::base() . 'index.php?option=com_tabulizer&task=dialog&tmpl=component&use_comments='.$tabulizer_directive_add_comments;		
		
		$tinymce_warning_msg = JText::_('PLG_TABULIZER_INVALID_EDITOR');

		$js = "												
			function tabulizerClickCallback( editor, result )
			{
			  if( result ) {			  
				jInsertEditorText( result, editor );	
			  }
			}
			
			function tabulizerOpenDialog( editor )
			{			  
			  if ($no_use_permissions) {
			   	  alert('{$no_use_permissions_warning_msg}');
				  return;
			  }
			  var durl = '{$popup_url}&clb_name=' + editor;
			  var wnd = window.open( durl, '_blank', 'status=no,resizable=yes,width=720,height=680,left=50,top=50' );
			  wnd.focus();
			  return wnd;			   	  
			}			
			";

		$doc->addScriptDeclaration($js);
		
		if(version_compare(JVERSION,'1.6.0','ge')) {
			// Joomla! 1.6 code here
			$plugin_dir = 'plugins/editors-xtd/tabulizer/tabulizer';
		} else {
			// Joomla! 1.5 code here
			$plugin_dir = 'plugins/editors-xtd/tabulizer';
		}
		
		$css = " .button2-left .Tabulizer { background: url(../{$plugin_dir}/assets/tabulizer_button.png) 100% 0 no-repeat; } ";
		
		$doc->addStyleDeclaration($css);
		
		$button = new JObject();
		$button->set('modal', false);
		$button->set('onclick', 'tabulizerOpenDialog(\''.$name.'\'); return false;');
		$button->set('text', JText::_('PLG_TABULIZER_BUTTON_LABEL'));
		$button->set('name', 'Tabulizer');
		$button->set('link', 'javascript:void(0)');

		return $button;
	}
	
}

?>