<?php
/**
 * Insert HTML table editor button plugin for Joomla! 
 *   
 * @package HTML editor plugin for Joomla!
 * @author Dimitrios Mourloukos <info@alterora.gr> 
 * @GNU General Public License   
 */ 

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class plgButtonRetabulizer extends JPlugin
{
	/**
	 * Constructor	 
	 */
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}
	
	public function onDisplay($name)
	{		
		$app = JFactory::getApplication();

		$doc		= JFactory::getDocument();
		$template	= $app->getTemplate();
		
		if(version_compare(JVERSION,'1.6.0','ge')) {
			$tabulizer_plugin = JPluginHelper::getPlugin('editors-xtd', 'tabulizer');
			$tabulizerPluginParams = new JRegistry();
			$tabulizerPluginParams->loadString($tabulizer_plugin->params);
			$tabulizer_directive_add_comments = 0;
		} else {
			$tabulizer_plugin = &JPluginHelper::getPlugin('editors-xtd', 'tabulizer');
			$tabulizerPluginParams = new JParameter($tabulizer_plugin->params);
			$tabulizer_directive_add_comments = 0;
		}
		
		$popup_url = JURI::base() . 'index.php?option=com_tabulizer&task=dialog&tmpl=component&use_comments='.$tabulizer_directive_add_comments;
		
		$tinymce_warning_msg = JText::_('PLG_RETABULIZER_INVALID_EDITOR');
		
		require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_tabulizer'.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'permissions.php');
		$perm = new TabulizerPermissions();				
		$no_use_permissions = ($perm->isAllowed('ruleset-use'))?0:1;
		$no_use_permissions_warning_msg = addslashes(JText::_('PLG_RETABULIZER_RULESET_USE_PERMISSION_INVALID'));
				
		$setOriginalContent = $this->_subject->setContent($name, 'original_content' );
		$setNewContent = $this->_subject->setContent($name, 'new_content' );
		
		// fix Joomla 1.5 bug
		$setOriginalContent = str_replace("'original_content'","original_content",$setOriginalContent);
		$setNewContent = str_replace("'new_content'","new_content",$setNewContent);		

		$js = "																					
			
			function retabulizerGetCaretPosition (editor) 
			{				
				var LOCATION_TOKEN = '{TABULIZER-CARET-POSITION-MARK-F6ZX7E39DE6G}';
				var original_content = ".$this->_subject->getContent($name)."
				jInsertEditorText( LOCATION_TOKEN, editor );			
				var content = ".$this->_subject->getContent($name)."
				var caret_position = content.indexOf(LOCATION_TOKEN);  				
				{$setOriginalContent}
			  
			  	return caret_position;						
			}
			
			function retabulizerGetEditorContent () 
			{
				var content = ".$this->_subject->getContent($name)."
				return content;
			}
			
			function retabulizerOpenDialog( editor )
			{			  
				if ($no_use_permissions) {
				    alert('{$no_use_permissions_warning_msg}');
					return;
				}											  
				var caret_position = retabulizerGetCaretPosition (editor);
				var durl = '{$popup_url}&clb_name=' + editor + '&caret_position=' + caret_position;
				var wnd = window.open( durl, '_blank', 'status=no,resizable=yes,width=720,height=680,left=50,top=50' );
				wnd.focus();
				return wnd;				
			}
						
			function retabulizerClickCallback( editor, result, replace_from, replace_to )
			{
			  if (result) {  			  				  
			  	var r1 = parseInt(replace_from);
				var r2 = parseInt(replace_to);																							
				
				var content = ".$this->_subject->getContent($name)."
				var new_content = content.substr(0,r1) + result + content.substr(r2+1);
				$setNewContent
			  }
			}			
			";

		$doc->addScriptDeclaration($js);
		
		if(version_compare(JVERSION,'1.6.0','ge')) {
			// Joomla! 1.6 code here
			$plugin_dir = 'plugins/editors-xtd/tabulizer/tabulizer';
		} else {
			// Joomla! 1.5 code here
			$plugin_dir = 'plugins/editors-xtd/tabulizer';
		}
		
		$css = " .button2-left .Retabulizer { background: url(../{$plugin_dir}/assets/retabulizer_button.png) 100% 0 no-repeat; } ";
		
		$doc->addStyleDeclaration($css);
		
		$button = new JObject();
		$button->set('modal', false);
		$button->set('onclick', 'retabulizerOpenDialog(\''.$name.'\'); return false;');
		$button->set('text', JText::_('PLG_RETABULIZER_BUTTON_LABEL'));
		$button->set('name', 'Retabulizer');
		$button->set('link', 'javascript:void(0)');

		return $button;
	}
	
}

?>