<?php
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchives'));

JHTML::_('behavior.tooltip');
$text = JText::_('COM_TABULIZER_IMPORT' );
JToolBarHelper::title(   JText::_('COM_TABULIZER_RULESET_ARCHIVE' ).': <small><small>[ ' . $text.' ]</small></small>','config' );
JToolBarHelper::custom('import', 'import_archive', 'import_archive', JText::_('COM_TABULIZER_IMPORT'), false, false );
JToolBarHelper::cancel( 'cancel', JText::_('COM_TABULIZER_CLOSE') );
JToolBarHelper::help( 'all_topics', true );

$cssfile = JURI::root() . 'administrator/components/com_tabulizer/assets/css/tabulizer.css';
$doc=JFactory::getDocument();
$doc->addStyleSheet($cssfile);
?>

<script language="javascript" type="text/javascript">		
	
	function isValidFilename(filename) {				
		regex = /[a-zA-Z0-9\._\-]{2,128}\.zip$/i;
		value = filename;
		if (!regex.test(value)) {
			return false;
		}		
		return true;
	}
	
	function validateAndSubmit() {
		var form = document.adminForm;	
		var value, regex, valid = true, error_msg = "";
		if (form.zip_filename.value == "") {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_FILE_UPLOAD_ERROR_NO_FILE');?>";
			valid = false;		
		} else if (!isValidFilename(form.zip_filename.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_ARCHIVE_FILENAME_IMPORT');?>";
			valid = false;		
		}				
				
		if (valid) {
			form.submit();
		} else {
			error_msg = "<?php echo JText::_('COM_TABULIZER_JS_ERRORS_FOUND'); ?>" + error_msg;
			alert(error_msg);
		}	
						
	}

<?php if(version_compare(JVERSION,'1.6.0','ge')) { ?>	

	Joomla.submitbutton = function(pressbutton) {											
		if (pressbutton == 'import') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}		
	}

<?php } else { ?>
	
	function submitbutton(pressbutton) {											
		if (pressbutton == 'import') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}		
	}	
	
<?php } ?>	
	
</script>

<form action="index.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
<div class="col width-60">
	<fieldset class="adminform">
		<legend><?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_IMPORT_DETAILS' ); ?></legend>
		<table class="admintable">
		<tr>
			<td align="right" class="key">				
				<?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_FILENAME_ZIP' ); ?>:			
			</td>
			<td>
				<?php echo $this->lists['filename']; ?>
			</td>			
		</tr>
		<tr>
			<td align="right" class="key">												
				<?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_OVERWRITE_LABEL' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['overwrite']; ?>
			</td>			
		</tr>						
	    </table>
	</fieldset>
</div>

<div class="clr"></div>
	<input type="hidden" name="option" value="com_tabulizer" />		
	<input type="hidden" name="task" value="importRulesetArchive" />
	<input type="hidden" name="import_file" value="1" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>

<?php
TabulizerUserMessage::printHelp(JText::_('COM_TABULIZER_FORM_RULESET_ARCHIVE_IMPORT_HELP'));
echo "<br/>\n";
TabulizerUserMessage::printWarning(JText::_('COM_TABULIZER_FORM_RULESET_ARCHIVE_IMPORT_WARNING'));
?>
