<?php
/**
 * @version		2.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

JHTML::_('behavior.tooltip');
JToolBarHelper::title(JText::_('COM_TABULIZER_RULESET_ARCHIVES'));

if (empty($this->ruleset_archives)) {
	JToolBarHelper::addNew('newRulesetArchive', JText::_('COM_TABULIZER_NEW_RULESET_ARCHIVE'));
	JToolBarHelper::help( 'archives', true );
} else {	
	JToolBarHelper::addNew('newRulesetArchive', JText::_('COM_TABULIZER_NEW_RULESET_ARCHIVE'));
	JToolBarHelper::custom( 'importRulesetArchive', 'import_archive', 'import_archive', JText::_('COM_TABULIZER_IMPORT_RULESET_ARCHIVE'), false, false );
	JToolBarHelper::deleteList(JText::_('COM_TABULIZER_DELETE_RULESET_ARCHIVE_CONFIRM'), 'deleteRulesetArchive', JText::_('COM_TABULIZER_DELETE_RULESET_ARCHIVE'));
	JToolBarHelper::custom( 'exportRulesetArchiveCSS', 'export_css', 'export_css', JText::_('COM_TABULIZER_EXPORT_CSS'), true, false );
	JToolBarHelper::help( 'all_topics', true );
}

if (empty($this->ruleset_archives)) {	
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'message.php');
	$msg = sprintf(JText::_('COM_TABULIZER_NO_RULESET_ARCHIVES_WERE_FOUND'), JText::_('COM_TABULIZER_NEW_RULESET_ARCHIVE'));
	TabulizerUserMessage::printInfo($msg);	
?>
<form action="index.php" method="post" name="adminForm">
<input type="hidden" name="option" value="<?php echo $option; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0"/>
<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php		
}
else {
	$rows = &$this->ruleset_archives;
?>

<form action="index.php" method="post" name="adminForm">
<table class="adminlist">
	<thead>
		<tr>
			<th width="20"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($rows); ?>)" /></th>
			<th class="title"><?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_TITLE');?></th>
			<th><?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_NAME');?></th>
			<th><?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_FILENAME');?></th>
			<th><?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_STYLE');?></th>
			<th width="260"><?php echo JText::_('COM_TABULIZER_ACTIONS');?></th>
		</tr>
	</thead>
	<?php				
	jimport('joomla.filter.output');
	$k=0;
	$i=0;
	foreach ($rows as $archive_filename => $row) {
		$archive_name = $row['name'];
		$archive_title = $row['title'];
		$archive_filename_url = urlencode($archive_filename);
		$archive_style = $row['style'];
	
		$id = $archive_filename_url;
		$k=1-$k;							
		$checked = JHTML::_('grid.id', $i, $id);											
		$view_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=viewrulesetarchive&archive_filename='.$archive_filename_url.'&cid[]='.$id);
		$preview_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=viewrulesetarchivepreview&archive_filename='.$archive_filename_url.'&cid[]='.$id);
		$edit_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=editrulesetarchive&archive_filename='.$archive_filename_url.'&cid[]='.$id);
		$delete_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=deleterulesetarchive&cid[]='.$id.'&'. JUtility::getToken() .'=1');
		$export_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=exportrulesetarchivecss&archive_filename='.$archive_filename_url.'&cid[]='.$id);								
		$action_links = '<a href="'.$view_link.'">'.JText::_('COM_TABULIZER_VIEW').'</a> | <a href="'.$preview_link.'">'.JText::_('COM_TABULIZER_PREVIEW').'</a> | <a href="'.$edit_link.'">'.JText::_('COM_TABULIZER_EDIT').'</a> | <a href="'.$delete_link.'"  onclick="javascript:return confirm(\''.JText::_('COM_TABULIZER_DELETE_RULESET_ARCHIVE_CONFIRM').'\')">'.JText::_('COM_TABULIZER_DELETE').'</a> | <a href="'.$export_link.'">'.JText::_('COM_TABULIZER_EXPORT_CSS').'</a>';
		echo '<tr class="row'.$k.'"><td>'.$checked.'</td><td><a href="'.$view_link.'">'.$archive_title.'</a></td><td>'.$archive_name.'</td><td>'.$archive_filename.XML_FILE_EXT.'</td><td>'.$archive_style.'</td><td>'.$action_links.'</td></tr>' ."\n";
		$i++;
	}
	?>
</table>			
<input type="hidden" name="option" value="<?php echo $option; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0"/>
<?php echo JHTML::_( 'form.token' ); ?>
</form>

<?php
	if (!empty($this->ruleset_conflicts)) {
		$msg = JText::_('COM_TABULIZER_RULESET_CONFLICTS_FOUND') . "<br>\n";
		$msg .='<ol>';
		if (!empty($this->ruleset_conflicts['rulesets']['names'])) {
			$msg .='<li>';
			$msg .= '<strong>'.JText::_('COM_TABULIZER_RULESET_CONFLICTS_IN_NAMES').'</strong>' . "<br/>\n";
			$msg .= '<ul>';
			foreach ($this->ruleset_conflicts['rulesets']['names'] as $archive_filename => $name_conflicts) {
				$archive_filename .= XML_FILE_EXT;
				foreach ($name_conflicts as $name_conflict) {
					$msg .= '<li>'.sprintf(JText::_('COM_TABULIZER_RULESET_NAME_ALREADY_DEFINED'),$name_conflict['value'],$archive_filename,$name_conflict['already_defined'].XML_FILE_EXT).'</li>';
				}	
			}					
			$msg .= '</ul>';
			$msg .='</li>';			
		}
		if (!empty($this->ruleset_conflicts['rulesets']['titles'])) {										
			$msg .='<li>';
			$msg .= '<strong>'.JText::_('COM_TABULIZER_RULESET_CONFLICTS_IN_TITLES').'</strong>' . "<br>\n";
			$msg .= '<ul>';
			foreach ($this->ruleset_conflicts['rulesets']['titles'] as $archive_filename => $title_conflicts) {							
				$archive_filename .= XML_FILE_EXT;
				foreach ($title_conflicts as $title_conflict) {				
					$msg .= '<li>'.sprintf(JText::_('COM_TABULIZER_RULESET_TITLE_ALREADY_DEFINED'),$title_conflict['value'],$archive_filename,$title_conflict['already_defined'].XML_FILE_EXT).'</li>';
				}
			}					
			$msg .= '</ul>';
			$msg .='</li>';			
		}
		$msg .='</ol>';		
		
		echo "<br/><br/>\n";
		
		TabulizerUserMessage::printWarning($msg);
	}

} // if (empty($this->ruleset_archives))

?>

<br/>

<?php echo TabulizerUserMessage::printPromo(JText::_('COM_TABULIZER_FIND_MORE_RULESETS_PROMO')); ?>