<?php
/**
 * @version		1.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 *
 * @MVC architecture generated by MVC generator tool at http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

class tabulizerViewRulesetarchive extends JView
{
	function display($tpl = null){		
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$ruleset_archive = $model->getRulesetArchive();				
		
		if (!empty($ruleset_archive)) {
			$this->assignRef('archive_name', $ruleset_archive['name']);
			$this->assignRef('archive_title', $ruleset_archive['title']);
			$this->assignRef('archive_filename', $ruleset_archive['filename']);
			$this->assignRef('rulesets', $ruleset_archive['rulesets']);
		}
		
		parent::display($tpl);		
	}	
	
	function displayPreview($tpl = null){		
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$ruleset_archive = $model->getRulesetArchive();				
		
		if (!empty($ruleset_archive)) {
			$this->assignRef('archive_name', $ruleset_archive['name']);
			$this->assignRef('archive_title', $ruleset_archive['title']);
			$this->assignRef('archive_style', $ruleset_archive['style']);			
			$this->assignRef('archive_filename', $ruleset_archive['filename']);
			$this->assignRef('rulesets', $ruleset_archive['rulesets']);
		}
		
		parent::display($tpl);		
	}		
		
	function displayNew($tpl = null) {
		$option = JRequest::getCmd('option');				
		
		$model = $this->getModel();
	
		$lists = array();	
												
		$lists['edit'] = false;
		
		$lists['filename'] = '<input type="text" name="archive_filename" id="archive_filename" value="*'.XML_FILE_EXT.'">';
		$lists['name'] = '<input type="text" name="archive_name" id="archive_name" value="">';
		$lists['title'] = '<input type="text" name="archive_title" id="archive_title" value="">';
		$lists['style'] = '<input type="text" name="archive_style" id="archive_style" value="">';
		
		$lists['used_archive_names'] = '';
		$archive_names = $model->getAllRulesetArchiveNames(array($archive['name']));
		if (!empty($archive_names)) {
			$lists['used_archive_names'] = '"'.implode('","', $archive_names).'"';
		}			
		
		$lists['used_archive_filenames'] = '';
		$archive_filenames = $model->getAllRulesetArchiveFilenames(array($archive['filename']));
		if (!empty($archive_filenames)) {
			$lists['used_archive_filenames'] = '"'.implode('","', $archive_filenames).'"';
		}							
								
		$this->assignRef('lists', $lists);								
		
		parent::display($tpl);	
	}

	function displayEdit($tpl = null){		
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$archive = $model->getRulesetArchive();															
		
		$lists = array();			
		
		$lists['edit'] = true;
		
		$lists['filename'] = '<input type="text" name="archive_filename" id="archive_filename" value="'.$archive['filename'].XML_FILE_EXT.'" readonly style="background-color: #c9c9c9">';
		$lists['name'] = '<input type="text" name="archive_name" id="archive_name" value="'. htmlspecialchars($archive['name'],ENT_COMPAT,'UTF-8').'">';
		$lists['title'] = '<input type="text" name="archive_title" id="archive_title" value="'.htmlspecialchars($archive['title'],ENT_COMPAT,'UTF-8').'">';		
		$lists['style'] = '<input type="text" name="archive_style" id="archive_style" value="'.htmlspecialchars($archive['style'],ENT_COMPAT,'UTF-8').'">';
		
		$lists['used_archive_names'] = '';
		$archive_names = $model->getAllRulesetArchiveNames(array($archive['name']));
		if (!empty($archive_names)) {
			$lists['used_archive_names'] = '"'.implode('","', $archive_names).'"';
		}			
		
		$lists['used_archive_filenames'] = '';
		$archive_filenames = $model->getAllRulesetArchiveFilenames(array($archive['filename']));
		if (!empty($archive_filenames)) {
			$lists['used_archive_filenames'] = '"'.implode('","', $archive_filenames).'"';
		}					
				
		$this->assignRef('lists', $lists);						
		
		parent::display($tpl);
	}				

}
?>