<?php

// no direct access
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'message.php');

$archive_filename = $this->ruleset_file;
$ruleset_name = $this->ruleset_name;
$ruleset_title = $this->ruleset_title;
$ruleset_description = $this->ruleset_description;
$ruleset_style = empty($this->ruleset_style)?$this->ruleset_style_inherited:$this->ruleset_style;
$ruleset_name_url = urlencode($ruleset_name);
$archive_filename_url = urlencode($archive_filename);

$ruleset_sample_data_text = (empty($this->sample_data_text))?null:$this->sample_data_text;
$ruleset_sample_data_sep = (empty($this->sample_data_sep))?'cm':$this->sample_data_sep;
$ruleset_sample_data_enc = (empty($this->sample_data_enc))?'none':$this->sample_data_enc;

$title = JText::_('COM_TABULIZER_RULESET' );
if (!empty($ruleset_title)) $title .= ': ' . $ruleset_title;
else if (!empty($ruleset_name)) $title .= ': '.$ruleset_name;
else $title .= ': '.$archive_filename.XML_FILE_EXT;
$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchive&archive_filename='.$archive_filename_url));

JHTML::_('behavior.tooltip');
JToolBarHelper::title($title);
JToolBarHelper::back(JText::_('COM_TABULIZER_BACK_TO_RULESET_ARCHIVE'), $return_url);
JToolBarHelper::help( 'all_topics', true );

$class_path = TABULIZER_INCLUDE_PATH . 'assets' . DS . 'class.php';
$rules_path = JPATH_SITE . DS. RULES_XML_DIR;
$css_path = JPATH_SITE . DS. RULES_CSS_DIR;

if (!file_exists($class_path)) {
	TabulizerUserMessage::printError(JText::_('COM_TABULIZER_PLUGIN_NOT_INSTALLED'));	
} else {	
	require_once($class_path);
	$table = new Tabulizer();	
	$table->setDir($rules_path);
	
	// load applicable css styles 
	if (!empty($ruleset_style)) {
		$ruleset_css_files = explode(';',$ruleset_style);		
		$cssfiles = array();
		$dir = $css_path;
		$url_dir = JURI::root() . RULES_CSS_DIR;				
		if (is_dir($dir)) {
			if ($dh = opendir($dir)) {					
				while (($file = readdir($dh)) !== false) {				
					if (is_file($dir . $file)) {
						if (in_array($file,$ruleset_css_files)) {
							$cssfiles[] = $url_dir . $file;
						}					
					}
				}	
				closedir($dh);
			} 			
		}
		if (!empty($cssfiles)) {
			$doc=JFactory::getDocument();
			foreach ($cssfiles as $cssfile) {					
				$doc->addStyleSheet($cssfile);
			}
		}		
	}

	echo '<strong><em>'.JText::_('COM_TABULIZER_SAMPLE_TABLE').'</em></strong>' . "<br/>\n";
	
	$name = $ruleset_name;
	$title = $ruleset_title;
	$description = $ruleset_description;		
	$html = '';
	$errors = array();
	
	if (!empty($description)) {
		$tooltip = JHTML::tooltip($description, $title);
		$title = $title . ' ' . $tooltip;
	}		
		
	echo "<hr><h3>{$title}</h3>\n";	
	
	if ($table->previewRuleset($name, $html, $errors, $ruleset_sample_data_text, $ruleset_sample_data_sep, $ruleset_sample_data_enc)) {
		echo $html;			
	} else {
		$msg = JText::_('COM_TABULIZER_ERRORS_FOUND'). '<br/><ul>';
		foreach ($errors as $error) {
			$msg .= '<li>'.$error.'</li>';
		}
		$msg .= '</ul>';
		TabulizerUserMessage::printError($msg);
	}

}		

?>
