<?php
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchive&archive_filename='.urlencode($this->lists['filename_value'])));
$used_ruleset_name = $this->lists['used_ruleset_names'];
$used_ruleset_title = $this->lists['used_ruleset_titles'];

JHTML::_('behavior.tooltip');
$edit = $this->lists['edit'];
$text = !$edit ? JText::_('COM_TABULIZER_NEW' ) : JText::_('COM_TABULIZER_EDIT' );
JToolBarHelper::title(   JText::_('COM_TABULIZER_RULESET' ).': <small><small>[ ' . $text.' ]</small></small>','config' );
JToolBarHelper::save();
if (!$edit)  {
	JToolBarHelper::cancel();
} else {
	// for existing items the button is renamed `close`
	JToolBarHelper::cancel( 'cancel', JText::_('COM_TABULIZER_CLOSE') );
}
JToolBarHelper::help( 'all_topics', true );

$cssfile = JURI::root() . 'administrator/components/com_tabulizer/assets/css/tabulizer.css';
$doc=JFactory::getDocument();
$doc->addStyleSheet($cssfile);

?>

<script language="javascript" type="text/javascript">		
	

	function isUsedName(name) {
		var used_names = [<?php echo $used_ruleset_name; ?>];
		if (used_names.indexOf(name) >=0) return true;
		else return false;
	}
	
	function isUsedTitle(title) {
		var used_titles = [<?php echo $used_ruleset_title; ?>];
		if (used_titles.indexOf(title) >=0) return true;
		else return false;
	}
	
	function updateSampleData(btn) {
		var span = document.getElementById('sample_data_span');
		if (btn.checked) {
			span.className = '';
		} else {
			span.className = 'hidden_span';
		}
	}
	
	function validateSampleData() {
		var flag = document.getElementById('sample_data_check').checked;
		var text = document.getElementById('sample_data_text').value;
		if ((flag) && (text=="")) return false; else return true;
	}
	
	function validateAndSubmit() {
		var form = document.adminForm;	
		var value, regex, valid = true, error_msg = "";
				
		regex = /^.{2,128}$/;
		value = form.ruleset_title.value;
		if (!regex.test(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_TITLE');?>";
			valid = false;		
		} else if (isUsedTitle(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_RULESET_TITLE_ALREADY_IN_USE');?>";
			valid = false;		
		}
		
		regex = /^[a-zA-Z0-9\._\-]{2,128}$/;
		value = form.ruleset_name.value;
		if (!regex.test(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_NAME');?>";
			valid = false;		
		} else if (isUsedName(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_RULESET_NAME_ALREADY_IN_USE');?>";
			valid = false;		
		}
		
		regex = /^[a-zA-Z0-9_\-]{2,128}$/;
		value = form.ruleset_suffix.value;
		if (!regex.test(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_SUFFIX');?>";
			valid = false;		
		}
						
		regex = /^([a-zA-Z0-9\._\-]{2,128}\.css)+(;[a-zA-Z0-9\._\-]{2,128}\.css)*$/i;
		value = form.ruleset_style.value;
		if (value != '') {
			if (!regex.test(value)) {
				error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_STYLE');?>";
				valid = false;		
			}
		}
		
		if (!validateSampleData()) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_SAMPLE_DATA');?>";
			valid = false;		
		}
				
		if (valid) {
			form.submit();
		} else {
			error_msg = "<?php echo JText::_('COM_TABULIZER_JS_ERRORS_FOUND'); ?>" + error_msg;
			alert(error_msg);
		}	
						
	}
	
<?php if(version_compare(JVERSION,'1.6.0','ge')) { ?>		
	
	Joomla.submitbutton = function(pressbutton) {											
		if (pressbutton == 'save') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}		
	}
	
<?php } else { ?>
	
	function submitbutton(pressbutton) {
		if (pressbutton == 'save') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}											
	}	
	
<?php } ?>	
	
</script>


<form action="index.php" method="post" name="adminForm" id="adminForm">
<div class="col width-60">
	<fieldset class="adminform">
		<legend><?php echo JText::_('COM_TABULIZER_RULESET_DETAILS' ); ?></legend>

		<table class="admintable">
		<tr>
			<td valign="top" align="right" class="key">				
				<?php echo JText::_('COM_TABULIZER_RULESET_TITLE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['title']; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_DESCRIPTION' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['description']; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_NAME' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['name']; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_SUFFIX' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['suffix']; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_STYLE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['style']; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_PRESELECTED' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['preselected']; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_SAMPLE_DATA_LABEL' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['sample_data']; ?>
			</td>
		</tr>				
	    </table>
	</fieldset>
</div>

<div class="clr"></div>
	<input type="hidden" name="option" value="com_tabulizer" />			
	<input type="hidden" name="task" value="saveRuleset" />
	<?php echo JHTML::_( 'form.token' ); ?>
	<?php echo $this->lists['filename']; ?>
</form>

<?php
TabulizerUserMessage::printHelp(JText::_('COM_TABULIZER_FORM_RULESET_HELP'));
?>