<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

$archive_filename = $this->ruleset_file;
$ruleset_name = $this->ruleset_name;
$ruleset_title = $this->ruleset_title;
$ruleset_name_url = urlencode($ruleset_name);
$archive_filename_url = urlencode($archive_filename);

$title = JText::_('COM_TABULIZER_RULESET' );
if (!empty($ruleset_title)) $title .= ': ' . $ruleset_title;
else if (!empty($ruleset_name)) $title .= ': '.$ruleset_name;
else $title .= ': '.$archive_filename.XML_FILE_EXT;
$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchive&archive_filename='.$archive_filename_url));

JHTML::_('behavior.tooltip');
JToolBarHelper::title($title);
JToolBarHelper::back(JText::_('COM_TABULIZER_BACK_TO_RULESET_ARCHIVE'), $return_url);
JToolBarHelper::addNew('newRule', JText::_('COM_TABULIZER_NEW_RULE'));
if (!empty($this->rules)) {
	JToolBarHelper::deleteList(JText::_('COM_TABULIZER_DELETE_RULE_CONFIRM'), 'deleteRule', JText::_('COM_TABULIZER_DELETE_RULE'));
}
JToolBarHelper::help( 'all_topics', true );

if (empty($this->rules)) {	
	$msg = sprintf(JText::_('COM_TABULIZER_NO_RULES_WERE_FOUND'), JText::_('COM_TABULIZER_NEW_RULE'));
	TabulizerUserMessage::printInfo($msg);	
?>
<form action="index.php" method="post" name="adminForm">
<input type="hidden" name="option" value="<?php echo $option; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="ruleset_name" value="<?php echo htmlspecialchars($ruleset_name,ENT_COMPAT,'UTF-8');?>" />
<input type="hidden" name="archive_filename" value="<?php echo htmlspecialchars($archive_filename,ENT_COMPAT,'UTF-8');?>" />
<input type="hidden" name="boxchecked" value="0"/>
<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php
} else {
	$rows = &$this->rules;			
?>
<form action="index.php" method="post" name="adminForm">
<table class="adminlist">
	<thead>
		<tr>
			<th width="20"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($rows); ?>)" /></th>
			<th class="title"><?php echo JText::_('COM_TABULIZER_ELEMENT_TYPE');?></th>
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_RANGE');?></th>
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_RANGE_COUNT');?></th>
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_STYLE');?></th>			
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_AUTOSPAN');?></th>
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_FORMAT');?></th>
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_REPLACEMENT');?></th>
			<th><?php echo JText::_('COM_TABULIZER_ELEMENT_CALCULATION');?></th>			
			<th width="220"><?php echo JText::_('COM_TABULIZER_ACTIONS');?></th>
		</tr>
	</thead>
	<?php				
	jimport('joomla.filter.output');
	$k=0;
	$i=0;
	foreach ($rows as $rule_id => $row) {						
		$rule_element = $row['element'];
		$rule_range = $row['range'];	
		$rule_range_count = $row['range_count'];
		$rule_style = $rule_autospan = $rule_format = $rule_replacement = $rule_calculation = '';
		
		if (!empty($row['style'])) {
			$rule_style = $row['style'];
		}
		if (!empty($row['autospan'])) {
			$rule_autospan = JText::_('COM_TABULIZER_AUTOSPAN_SELECTED');
		} 	
		if (!empty($row['format'])) {			
			list($data_type,$data_type_params) = explode(DATA_TYPE_SEPARATOR,$row['format']);
			switch ($data_type) {
				case DATA_TYPE_TEXT: 					
					$text_format = $data_type_params;					
					$options = array(FORMAT_TEXT_UPPERCASE => JText::_('COM_TABULIZER_FORMAT_TEXT_UPPERCASE'),
						FORMAT_TEXT_LOWERCASE => JText::_('COM_TABULIZER_FORMAT_TEXT_LOWERCASE'),
						FORMAT_TEXT_UCFIRST => JText::_('COM_TABULIZER_FORMAT_TEXT_UCFIRST'),
						FORMAT_TEXT_UCWORDS => JText::_('COM_TABULIZER_FORMAT_TEXT_UCWORDS'));	
					if (isset($options[$text_format])) {
						$rule_format = JText::_('COM_TABULIZER_DATA_TYPE_TEXT') . ' <em>' . $options[$text_format] . '</em>';
					}						
					break;
				case DATA_TYPE_NUMERIC: 
					list($numeric_decimals, $numeric_dec_point, $numeric_thousands_sep) = explode(FORMAT_NUMERIC_SEPARATOR, $data_type_params);
					$rule_format = JText::_('COM_TABULIZER_DATA_TYPE_NUMERIC');
					break;
				case DATA_TYPE_CURRENCY: 
					list($currency_decimals, $currency_dec_point, $currency_thousands_sep, $currency_symbol, $currency_symbol_order) = explode(FORMAT_CURRENCY_SEPARATOR, $data_type_params);
					$rule_format = JText::_('COM_TABULIZER_DATA_TYPE_CURRENCY');
					break;
				case DATA_TYPE_DATE: 
					$date_format = $data_type_params;
					$options = array(FORMAT_DATE_DDMMYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYY_1'),
						FORMAT_DATE_DDMMYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYY_2'),
						FORMAT_DATE_MMDDYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYY_1'),
						FORMAT_DATE_MMDDYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYY_2'),									
						FORMAT_DATE_DDMMYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_1'),
						FORMAT_DATE_DDMMYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_2'),
						FORMAT_DATE_DDMMYYYY_3 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_3'),
						FORMAT_DATE_MMDDYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_1'),									
						FORMAT_DATE_MMDDYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_2'),
						FORMAT_DATE_MMDDYYYY_3 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_3'),
						FORMAT_DATE_dDDMMYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDMMYYYY_1'),
						FORMAT_DATE_dDDMMYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDMMYYYY_2'),									
						FORMAT_DATE_dMMDDYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DMMDDYYYY_1'),
						FORMAT_DATE_dMMDDYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DMMDDYYYY_2'),
						FORMAT_DATE_dDDm_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDM_1'),
						FORMAT_DATE_dmDD_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DMDD_1'));
					if (isset($options[$date_format])) {
						$rule_format = JText::_('COM_TABULIZER_DATA_TYPE_DATE') . ' <em>' . $options[$date_format] . '</em>';
					}		
					break;
			}
		}				
		
		if (!empty($row['replacement'])) {
			list($replace_cs, $replace_from,$replace_to) = explode(REPLACEMENT_SEPARATOR,$row['replacement']);
			if ($replace_cs) $rule_replacement = '<em>(' . JText::_('COM_TABULIZER_REPLACEMENT_CS') . ')</em> ';			
			$rule_replacement .= $replace_from . ' -&gt; ' . $replace_to;
		}
		
		if (!empty($row['calculation'])) {
			$options = array(
			CALCULATION_NONE => JText::_('COM_TABULIZER_CALCULATION_NONE'), 
			CALCULATION_ADD_ABOVE => JText::_('COM_TABULIZER_CALCULATION_ADD_ABOVE'), 
			CALCULATION_ADD_BELOW => JText::_('COM_TABULIZER_CALCULATION_ADD_BELOW'), 
			CALCULATION_ADD_LEFT => JText::_('COM_TABULIZER_CALCULATION_ADD_LEFT'), 
			CALCULATION_ADD_RIGHT => JText::_('COM_TABULIZER_CALCULATION_ADD_RIGHT'), 
			CALCULATION_MUL_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MUL_ABOVE'), 
			CALCULATION_MUL_BELOW => JText::_('COM_TABULIZER_CALCULATION_MUL_BELOW'),  
			CALCULATION_MUL_LEFT => JText::_('COM_TABULIZER_CALCULATION_MUL_LEFT'),  
			CALCULATION_MUL_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MUL_RIGHT'), 
			CALCULATION_AVG_ABOVE => JText::_('COM_TABULIZER_CALCULATION_AVG_ABOVE'),  
			CALCULATION_AVG_BELOW => JText::_('COM_TABULIZER_CALCULATION_AVG_BELOW'), 
			CALCULATION_AVG_LEFT => JText::_('COM_TABULIZER_CALCULATION_AVG_LEFT'),  
			CALCULATION_AVG_RIGHT => JText::_('COM_TABULIZER_CALCULATION_AVG_RIGHT'),  
			CALCULATION_MED_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MED_ABOVE'),  
			CALCULATION_MED_BELOW => JText::_('COM_TABULIZER_CALCULATION_MED_BELOW'),  
			CALCULATION_MED_LEFT => JText::_('COM_TABULIZER_CALCULATION_MED_LEFT'),  
			CALCULATION_MED_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MED_RIGHT'),  
			CALCULATION_MIN_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MIN_ABOVE'),  
			CALCULATION_MIN_BELOW => JText::_('COM_TABULIZER_CALCULATION_MIN_BELOW'),  
			CALCULATION_MIN_LEFT => JText::_('COM_TABULIZER_CALCULATION_MIN_LEFT'),  
			CALCULATION_MIN_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MIN_RIGHT'),  
			CALCULATION_MAX_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MAX_ABOVE'), 
			CALCULATION_MAX_BELOW => JText::_('COM_TABULIZER_CALCULATION_MAX_BELOW'),  
			CALCULATION_MAX_LEFT => JText::_('COM_TABULIZER_CALCULATION_MAX_LEFT'),  
			CALCULATION_MAX_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MAX_RIGHT')); 
			
			if (isset($options[$row['calculation']])) {
				$rule_calculation = $options[$row['calculation']];
			}
		}
							
		$id = $i;
		$k=1-$k;					
		$checked = JHTML::_('grid.id', $i, $id);											
		$edit_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=editRule&rule_id='.$rule_id.'&ruleset_name='.$ruleset_name_url.'&archive_filename='.$archive_filename_url.'&cid[]='.$id);
		$delete_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=deleteRule&rule_id='.$rule_id.'&ruleset_name='.$ruleset_name_url.'&archive_filename='.$archive_filename_url.'&cid[]='.$id.'&'. JUtility::getToken() .'=1');
		$action_links = '<a href="'.$edit_link.'">'.JText::_('COM_TABULIZER_EDIT').'</a> | <a href="'.$delete_link.'" onclick="javascript:return confirm(\''.JText::_('COM_TABULIZER_DELETE_RULE_CONFIRM').'\')">'.JText::_('COM_TABULIZER_DELETE').'</a>';
		echo '<tr class="row'.$k.'"><td>'.$checked.'</td><td>'.$rule_element.'</a></td><td>'.$rule_range.'</td><td>'.$rule_range_count.'</td><td>'.$rule_style.'</td><td>'.$rule_autospan.'</td><td>'.$rule_format.'</td><td>'.$rule_replacement.'</td><td>'.$rule_calculation.'</td><td>'.$action_links.'</td></tr>' ."\n";
		$i++;
	}
	?>
</table>			
<input type="hidden" name="option" value="<?php echo $option; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="ruleset_name" value="<?php echo htmlspecialchars($ruleset_name,ENT_COMPAT,'UTF-8');?>" />
<input type="hidden" name="archive_filename" value="<?php echo htmlspecialchars($archive_filename,ENT_COMPAT,'UTF-8');?>" />
<input type="hidden" name="boxchecked" value="0"/>
<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php
} // if (!empty($this->rules))
?>
