<?php
/**
 * @version		1.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 *
 * @MVC architecture generated by MVC generator tool at http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

class tabulizerViewRule extends JView
{
	function display($tpl = null){				
		parent::display($tpl);
	}	
	
	function displayNew($tpl = null) {
		global $option, $mainframe;		
		
		$model = $this->getModel();
		$ruleset = $model->getRuleset();							
		
		$lists = array();	
		$row_selected = $column_selected = $cell_selected = '';
		$element_value = $range_value = $style_value = '';				
		$range_count = 0;
						
		$lists['edit'] = false;
		
		$lists['element'] = '<select name="element" id="element">' . 
				'<option value="row" '.$row_selected.'>'.JText::_('COM_TABULIZER_ROW').'</option>' .  
				'<option value="column" '.$column_selected.'>'.JText::_('COM_TABULIZER_COLUMN').'</option>' .  
				'<option value="cell" '.$cell_selected.'>'.JText::_('COM_TABULIZER_CELL').'</option>' .  
				'</select>';
		$lists['range'] = '<input type="text" name="range" id="range" value="'.$range_value.'" />';
		$lists['range_count'] = '<input type="text" name="range_count" id="range_count" value="'.$range_count.'" />';
		$lists['style'] = '<input type="text" name="style" id="style" value="'.$style_value.'" />';					
		
		# init vars
		$autospan = null;
		
		$text_format = null;
		$numeric_decimals = null;
		$numeric_dec_point = null;
		$numeric_thousands_sep = null;
		$currency_decimals = null;
		$currency_dec_point = null;
		$currency_thousands_sep = null;
		$currency_symbol = null;
		$currency_symbol_order = null;
		$date_format = null;
		
		$calculation = null;
		
		# autospan
		if (!empty($autospan)) {
			$autospan_selected = $checkbox_selected;	
		}			
		
		$lists['autospan'] = '<input type="checkbox" name="autospan" id="autospan" value="1" '.$autospan_selected.' />' . JText::_('COM_TABULIZER_AUTOSPAN_SELECTED');					
		
		# format							
		$lists['format'] = '';	
			
		$options = array(DATA_TYPE_UNDEFINED => JText::_('COM_TABULIZER_DATA_TYPE_UNDEFINED'), 
						DATA_TYPE_TEXT => JText::_('COM_TABULIZER_DATA_TYPE_TEXT'), 
						DATA_TYPE_NUMERIC => JText::_('COM_TABULIZER_DATA_TYPE_NUMERIC'), 
						DATA_TYPE_CURRENCY => JText::_('COM_TABULIZER_DATA_TYPE_CURRENCY'), 
						DATA_TYPE_DATE => JText::_('COM_TABULIZER_DATA_TYPE_DATE'));	
		$selected_value = empty($data_type)?DATA_TYPE_UNDEFINED:$data_type;
		$format_data_type_options = $this->getSelectOptions($options, $selected_value);			
		$lists['format'] .= '<select name="format_data_type" id="format_data_type" onChange="updateDataType(this)">' . $format_data_type_options .  '</select>';								
		
		$format_text_params_div_class = $format_numeric_params_div_class = $format_currency_params_div_class = $format_date_params_div_class = 'hidden_span';
		switch ($data_type) {
			case DATA_TYPE_TEXT: $format_text_params_div_class = ''; break;
			case DATA_TYPE_NUMERIC: $format_numeric_params_div_class = ''; break;
			case DATA_TYPE_CURRENCY: $format_currency_params_div_class = ''; break;
			case DATA_TYPE_DATE: $format_date_params_div_class = ''; break; 			
		}
			
		$options = array(FORMAT_TEXT_UPPERCASE => JText::_('COM_TABULIZER_FORMAT_TEXT_UPPERCASE'),
						FORMAT_TEXT_LOWERCASE => JText::_('COM_TABULIZER_FORMAT_TEXT_LOWERCASE'),
						FORMAT_TEXT_UCFIRST => JText::_('COM_TABULIZER_FORMAT_TEXT_UCFIRST'),
						FORMAT_TEXT_UCWORDS => JText::_('COM_TABULIZER_FORMAT_TEXT_UCWORDS'));	
		$selected_value = empty($text_format)?FORMAT_TEXT_UPPERCASE:$text_format;
		$format_text_params_options = $this->getSelectOptions($options, $selected_value);					
		
		$numeric_decimals_options = '';
		$currency_decimals_options = '';
		for ($i=0;$i<10;$i++) {
			if ($i==$numeric_decimals) {
				$numeric_decimals_options .= '<option value="'.$i.'" '.$select_selected.'>'.$i.'</option>';
			} else {
				$numeric_decimals_options .= '<option value="'.$i.'">'.$i.'</option>';
			}	
			if ($i==$currency_decimals) {
				$currency_decimals_options .= '<option value="'.$i.'" '.$select_selected.'>'.$i.'</option>';
			} else {
				$currency_decimals_options .= '<option value="'.$i.'">'.$i.'</option>';
			}	
		}				
					
		$options = array(FORMAT_NUMERIC_DEC_POINT_COMMA => JText::_('COM_TABULIZER_FORMAT_NUMERIC_DEC_POINT_COMMA'), FORMAT_NUMERIC_DEC_POINT_PERIOD => JText::_('COM_TABULIZER_FORMAT_NUMERIC_DEC_POINT_PERIOD'));
		
		$selected_value = empty($numeric_dec_point)?FORMAT_NUMERIC_DEC_POINT_PERIOD:$numeric_dec_point;
		$numeric_dec_point_options = $this->getSelectOptions($options, $selected_value);				
		
		$selected_value = empty($numeric_thousands_sep)?FORMAT_NUMERIC_DEC_POINT_COMMA:$numeric_thousands_sep;
		$numeric_thousands_sep_options = $this->getSelectOptions($options, $selected_value);	
		
		$selected_value = empty($currency_dec_point)?FORMAT_NUMERIC_DEC_POINT_PERIOD:$currency_dec_point;
		$currency_dec_point_options = $this->getSelectOptions($options, $selected_value);		
		
		$selected_value = empty($currency_thousands_sep)?FORMAT_NUMERIC_DEC_POINT_COMMA:$currency_thousands_sep;
		$currency_thousands_sep_options = $this->getSelectOptions($options, $selected_value);
		
		$currency_symbol = empty($currency_symbol)?'&euro;':$currency_symbol;
			
		$options = array(FORMAT_CURRENCY_SYMBOL_ORDER_NONE => JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER_NONE'), FORMAT_CURRENCY_SYMBOL_ORDER_BEFORE => JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER_BEFORE'), FORMAT_CURRENCY_SYMBOL_ORDER_AFTER => 	JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER_AFTER'));
		$selected_value = empty($currency_symbol_order)?FORMAT_CURRENCY_SYMBOL_ORDER_NONE:$currency_symbol_order;
		$currency_symbol_order_options = $this->getSelectOptions($options, $selected_value);			
		
		$options = array(FORMAT_DATE_DDMMYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYY_1'),
						FORMAT_DATE_DDMMYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYY_2'),
						FORMAT_DATE_MMDDYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYY_1'),
						FORMAT_DATE_MMDDYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYY_2'),									
						FORMAT_DATE_DDMMYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_1'),
						FORMAT_DATE_DDMMYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_2'),
						FORMAT_DATE_DDMMYYYY_3 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_3'),
						FORMAT_DATE_MMDDYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_1'),									
						FORMAT_DATE_MMDDYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_2'),
						FORMAT_DATE_MMDDYYYY_3 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_3'),
						FORMAT_DATE_dDDMMYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDMMYYYY_1'),
						FORMAT_DATE_dDDMMYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDMMYYYY_2'),									
						FORMAT_DATE_dMMDDYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DMMDDYYYY_1'),
						FORMAT_DATE_dMMDDYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DMMDDYYYY_2'),
						FORMAT_DATE_dDDm_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDM_1'),
						FORMAT_DATE_dmDD_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DMDD_1'));
		$selected_value = empty($date_format)?FORMAT_DATE_DDMMYY_1:$date_format;				
		$format_date_params_options = $this->getSelectOptions($options, $selected_value);				
						
		$lists['format'] .= '
		<div id="format_params_div">
		
		<span id="format_text_params_div" class="'.$format_text_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td><select name="format_text_params" id="format_text_params">'.$format_text_params_options.'</select></td></tr>' .		
		'</table></div>
		</span>

		<span id="format_numeric_params_div" class="'.$format_numeric_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_NUMERIC_DECIMALS').':</td><td><select name="format_numeric_decimals" id="format_numeric_decimals">'.$numeric_decimals_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_NUMERIC_DEC_POINT'). ':</td><td><select name="format_numeric_dec_point" id="format_numeric_dec_point">'.$numeric_dec_point_options.'</select></td></tr>' . 
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_NUMERIC_THOUSANDS_SEP'). ':</td><td><select name="format_numeric_thousands_sep" id="format_numeric_thousands_sep">'.$numeric_thousands_sep_options.'</select></td></tr>' .
			'</table></div>
		</span>
		
		<span id="format_currency_params_div" class="'.$format_currency_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_DECIMALS').':</td><td><select name="format_currency_decimals" id="format_currency_decimals">'.$currency_decimals_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_DEC_POINT'). ':</td><td><select name="format_currency_dec_point" id="format_currency_dec_point">'.$currency_dec_point_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_THOUSANDS_SEP'). ':</td><td><select name="format_currency_thousands_sep" id="format_currency_thousands_sep">'.$currency_thousands_sep_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL').':</td><td><input type="text" name="format_currency_symbol" id="format_currency_symbol" length="6" maxlength="24" value="'.$currency_symbol.'"></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER').':</td><td><select name="format_currency_symbol_order" id="format_currency_symbol_order">'.$currency_symbol_order_options.'</select></td></tr>' .
			'</table></div>
		</span>				
		
		<span id="format_date_params_div" class="'.$format_date_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td><select name="format_date_params" id="format_date_params">'.$format_date_params_options.'</select></td></tr>' .		
		'</table></div>
		</span>
		
		</div>';
		
		$lists['format'] .= '<input type="hidden" name="format_data_type_params" id="format_data_type_params" value="'.$data_type_params.'">';							
		
		# replacement
		$replace_cs = 'checked="checked"';
		$replace_from = $replace_to = '';
		$lists['replacement'] = '<span style="float: left; width: auto; margin: 5px 5px 5px 0px;">'. JText::_('COM_TABULIZER_REPLACEMENT_FROM'). '</span><input type="text" name="replace_from" id="replace_from" value="'.$replace_from.'" >' .
								'<span style="float: left; width: auto; margin: 5px 5px 5px 0px;">'.JText::_('COM_TABULIZER_REPLACEMENT_TO'). '</span><input type="text" name="replace_to" id="replace_to" value="'.$replace_to.'" >' .
								'<span style="float: left; width: auto; margin: 5px 5px 5px 0px;">'.JText::_('COM_TABULIZER_REPLACEMENT_CS'). '</span><input type="checkbox" name="replace_cs" id="replace_cs" value="1" '.$replace_cs.' >'; 								

		
		# calculation
		if (!empty($calculation)) {
			$calculation_value = $rule['calculation'];
		}
		
		$options = array(
			CALCULATION_NONE => JText::_('COM_TABULIZER_CALCULATION_NONE'), 
			CALCULATION_ADD_ABOVE => JText::_('COM_TABULIZER_CALCULATION_ADD_ABOVE'), 
			CALCULATION_ADD_BELOW => JText::_('COM_TABULIZER_CALCULATION_ADD_BELOW'), 
			CALCULATION_ADD_LEFT => JText::_('COM_TABULIZER_CALCULATION_ADD_LEFT'), 
			CALCULATION_ADD_RIGHT => JText::_('COM_TABULIZER_CALCULATION_ADD_RIGHT'), 
			CALCULATION_MUL_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MUL_ABOVE'), 
			CALCULATION_MUL_BELOW => JText::_('COM_TABULIZER_CALCULATION_MUL_BELOW'),  
			CALCULATION_MUL_LEFT => JText::_('COM_TABULIZER_CALCULATION_MUL_LEFT'),  
			CALCULATION_MUL_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MUL_RIGHT'), 
			CALCULATION_AVG_ABOVE => JText::_('COM_TABULIZER_CALCULATION_AVG_ABOVE'),  
			CALCULATION_AVG_BELOW => JText::_('COM_TABULIZER_CALCULATION_AVG_BELOW'), 
			CALCULATION_AVG_LEFT => JText::_('COM_TABULIZER_CALCULATION_AVG_LEFT'),  
			CALCULATION_AVG_RIGHT => JText::_('COM_TABULIZER_CALCULATION_AVG_RIGHT'),  
			CALCULATION_MED_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MED_ABOVE'),  
			CALCULATION_MED_BELOW => JText::_('COM_TABULIZER_CALCULATION_MED_BELOW'),  
			CALCULATION_MED_LEFT => JText::_('COM_TABULIZER_CALCULATION_MED_LEFT'),  
			CALCULATION_MED_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MED_RIGHT'),  
			CALCULATION_MIN_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MIN_ABOVE'),  
			CALCULATION_MIN_BELOW => JText::_('COM_TABULIZER_CALCULATION_MIN_BELOW'),  
			CALCULATION_MIN_LEFT => JText::_('COM_TABULIZER_CALCULATION_MIN_LEFT'),  
			CALCULATION_MIN_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MIN_RIGHT'),  
			CALCULATION_MAX_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MAX_ABOVE'), 
			CALCULATION_MAX_BELOW => JText::_('COM_TABULIZER_CALCULATION_MAX_BELOW'),  
			CALCULATION_MAX_LEFT => JText::_('COM_TABULIZER_CALCULATION_MAX_LEFT'),  
			CALCULATION_MAX_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MAX_RIGHT')); 
				
		$selected_value = empty($calculation_value)?CALCULATION_NONE:$calculation_value;				
		$calculation_options = $this->getSelectOptions($options, $selected_value);
				
		$lists['calculation'] = '<select name="calculation" id="calculation">'.$calculation_options.'</select>';
							
		$lists['rule_id'] = '<input type="hidden" name="rule_id" value="'.count($ruleset['rules']).'" />';
		$lists['ruleset_name'] = '<input type="hidden" name="ruleset_name" value="'.htmlspecialchars($ruleset['name'],ENT_COMPAT,'UTF-8').'" />';
		$lists['filename'] = '<input type="hidden" name="archive_filename" value="'.htmlspecialchars($ruleset['filename'],ENT_COMPAT,'UTF-8').'" />';
		
		$lists['rule_id_value'] = count($ruleset['rules']);
		$lists['ruleset_name_value'] = $ruleset['name'];
		$lists['filename_value'] = $ruleset['filename'];
		
		$this->assignRef('lists', $lists);						
		
		parent::display($tpl);	
	}

	function displayEdit($tpl = null){		
		global $option, $mainframe;		
		
		$model = $this->getModel();
		$rule = $model->getRule();							
		
		$select_selected = 'selected="selected"';
		$checkbox_selected = 'checked="checked"';
		
		$lists = array();	
		$row_selected = $column_selected = $cell_selected = '';
		$element_value = $range_value = $style_value = '';
		$autospan_value = $format_value = $calculation_value = '';
		$range_count = 0;
		
		# element
		if (!empty($rule['element'])) {						
			if ($rule['element'] == 'row') 	$row_selected = $select_selected;
			else if ($rule['element'] == 'column') $column_selected = $select_selected;
			else if ($rule['element'] == 'cell') $cell_selected = $select_selected;																
		}
		
		$lists['element'] = '<select name="element" id="element">' . 
				'<option value="row" '.$row_selected.'>'.JText::_('COM_TABULIZER_ROW').'</option>' .  
				'<option value="column" '.$column_selected.'>'.JText::_('COM_TABULIZER_COLUMN').'</option>' .  
				'<option value="cell" '.$cell_selected.'>'.JText::_('COM_TABULIZER_CELL').'</option>' .
				'</select>';
				
		# range		
		if (!empty($rule['range'])) {				
			$range_value = $rule['range'];												
		}
		$lists['range'] = '<input type="text" name="range" id="range" value="'.$range_value.'" />';
		
		# range count
		if (!empty($rule['range_count'])) {				
			$range_count = $rule['range_count'];												
		}
		$lists['range_count'] = '<input type="text" name="range_count" id="range_count" value="'.$range_count.'" />';
		
		# style
		$style_value = '';
		if (!empty($rule['style'])) {
			$style_value = $rule['style'];		
		}
		
		$lists['style'] = '<input type="text" name="style" id="style" value="'.$style_value.'" />';					
		
		# autospan
		$autospan_selected = '';
		if (!empty($rule['autospan'])) {
			$autospan_selected = $checkbox_selected;	
		}			
		
		$lists['autospan'] = '<input type="checkbox" name="autospan" id="autospan" value="1" '.$autospan_selected.' />' . JText::_('COM_TABULIZER_AUTOSPAN_SELECTED');					
		
		# format
		$format_vars = array('text_format','numeric_decimals', 'numeric_dec_point', 'numeric_thousands_sep', 'currency_decimals', 'currency_dec_point', 'currency_thousands_sep', 'currency_symbol', 'currency_symbol_order','date_format');
		foreach ($format_vars as $format_var) {
			$$format_var = null;
		}
		
		if (!empty($rule['format'])) {
			$format_value = $rule['format'];
			list($data_type,$data_type_params) = explode(DATA_TYPE_SEPARATOR,$format_value);
			$data_type_params = html_entity_decode($data_type_params,ENT_QUOTES,'UTF-8');
			
			switch ($data_type) {
				case DATA_TYPE_TEXT: 					
					$text_format = $data_type_params;
					break;
				case DATA_TYPE_NUMERIC: 
					list($numeric_decimals, $numeric_dec_point, $numeric_thousands_sep) = explode(FORMAT_NUMERIC_SEPARATOR, $data_type_params);
					break;
				case DATA_TYPE_CURRENCY: 
					list($currency_decimals, $currency_dec_point, $currency_thousands_sep, $currency_symbol, $currency_symbol_order) = explode(FORMAT_CURRENCY_SEPARATOR, $data_type_params);
					break;
				case DATA_TYPE_DATE: 
					$date_format = $data_type_params;
					break;
			}
		}				
		
					
		$lists['format'] = '';	
			
		$options = array(DATA_TYPE_UNDEFINED => JText::_('COM_TABULIZER_DATA_TYPE_UNDEFINED'), 
						DATA_TYPE_TEXT => JText::_('COM_TABULIZER_DATA_TYPE_TEXT'), 
						DATA_TYPE_NUMERIC => JText::_('COM_TABULIZER_DATA_TYPE_NUMERIC'), 
						DATA_TYPE_CURRENCY => JText::_('COM_TABULIZER_DATA_TYPE_CURRENCY'), 
						DATA_TYPE_DATE => JText::_('COM_TABULIZER_DATA_TYPE_DATE'));	
		$selected_value = empty($data_type)?DATA_TYPE_UNDEFINED:$data_type;
		$format_data_type_options = $this->getSelectOptions($options, $selected_value);			
		$lists['format'] .= '<select name="format_data_type" id="format_data_type" onChange="updateDataType(this)">' . $format_data_type_options .  '</select>';				
		
		$format_text_params_div_class = $format_numeric_params_div_class = $format_currency_params_div_class = $format_date_params_div_class = 'hidden_span';
		switch ($data_type) {
			case DATA_TYPE_TEXT: $format_text_params_div_class = ''; break;
			case DATA_TYPE_NUMERIC: $format_numeric_params_div_class = ''; break;
			case DATA_TYPE_CURRENCY: $format_currency_params_div_class = ''; break;
			case DATA_TYPE_DATE: $format_date_params_div_class = ''; break; 			
		}		
			
		$options = array(FORMAT_TEXT_UPPERCASE => JText::_('COM_TABULIZER_FORMAT_TEXT_UPPERCASE'),
						FORMAT_TEXT_LOWERCASE => JText::_('COM_TABULIZER_FORMAT_TEXT_LOWERCASE'),
						FORMAT_TEXT_UCFIRST => JText::_('COM_TABULIZER_FORMAT_TEXT_UCFIRST'),
						FORMAT_TEXT_UCWORDS => JText::_('COM_TABULIZER_FORMAT_TEXT_UCWORDS'));	
		$selected_value = empty($text_format)?FORMAT_TEXT_UPPERCASE:$text_format;
		$format_text_params_options = $this->getSelectOptions($options, $selected_value);					
		
		$numeric_decimals_options = '';
		$currency_decimals_options = '';
		for ($i=0;$i<10;$i++) {
			if ($i==$numeric_decimals) {
				$numeric_decimals_options .= '<option value="'.$i.'" '.$select_selected.'>'.$i.'</option>';
			} else {
				$numeric_decimals_options .= '<option value="'.$i.'">'.$i.'</option>';
			}	
			if ($i==$currency_decimals) {
				$currency_decimals_options .= '<option value="'.$i.'" '.$select_selected.'>'.$i.'</option>';
			} else {
				$currency_decimals_options .= '<option value="'.$i.'">'.$i.'</option>';
			}	
		}				
					
		$options = array(FORMAT_NUMERIC_DEC_POINT_COMMA => JText::_('COM_TABULIZER_FORMAT_NUMERIC_DEC_POINT_COMMA'), FORMAT_NUMERIC_DEC_POINT_PERIOD => JText::_('COM_TABULIZER_FORMAT_NUMERIC_DEC_POINT_PERIOD'));
		
		$selected_value = empty($numeric_dec_point)?FORMAT_NUMERIC_DEC_POINT_PERIOD:$numeric_dec_point;
		$numeric_dec_point_options = $this->getSelectOptions($options, $selected_value);				
		
		$selected_value = empty($numeric_thousands_sep)?FORMAT_NUMERIC_DEC_POINT_COMMA:$numeric_thousands_sep;
		$numeric_thousands_sep_options = $this->getSelectOptions($options, $selected_value);	
		
		$selected_value = empty($currency_dec_point)?FORMAT_NUMERIC_DEC_POINT_PERIOD:$currency_dec_point;
		$currency_dec_point_options = $this->getSelectOptions($options, $selected_value);		
		
		$selected_value = empty($currency_thousands_sep)?FORMAT_NUMERIC_DEC_POINT_COMMA:$currency_thousands_sep;
		$currency_thousands_sep_options = $this->getSelectOptions($options, $selected_value);
		
		$currency_symbol = empty($currency_symbol)?'&euro;':$currency_symbol;
			
		$options = array(FORMAT_CURRENCY_SYMBOL_ORDER_NONE => JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER_NONE'), FORMAT_CURRENCY_SYMBOL_ORDER_BEFORE => JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER_BEFORE'), FORMAT_CURRENCY_SYMBOL_ORDER_AFTER => 	JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER_AFTER'));
		$selected_value = empty($currency_symbol_order)?FORMAT_CURRENCY_SYMBOL_ORDER_NONE:$currency_symbol_order;
		$currency_symbol_order_options = $this->getSelectOptions($options, $selected_value);			
		
		$options = array(FORMAT_DATE_DDMMYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYY_1'),
						FORMAT_DATE_DDMMYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYY_2'),
						FORMAT_DATE_MMDDYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYY_1'),
						FORMAT_DATE_MMDDYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYY_2'),									
						FORMAT_DATE_DDMMYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_1'),
						FORMAT_DATE_DDMMYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_2'),
						FORMAT_DATE_DDMMYYYY_3 => JText::_('COM_TABULIZER_FORMAT_DATE_DDMMYYYY_3'),
						FORMAT_DATE_MMDDYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_1'),									
						FORMAT_DATE_MMDDYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_2'),
						FORMAT_DATE_MMDDYYYY_3 => JText::_('COM_TABULIZER_FORMAT_DATE_MMDDYYYY_3'),
						FORMAT_DATE_dDDMMYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDMMYYYY_1'),
						FORMAT_DATE_dDDMMYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDMMYYYY_2'),									
						FORMAT_DATE_dMMDDYYYY_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DMMDDYYYY_1'),
						FORMAT_DATE_dMMDDYYYY_2 => JText::_('COM_TABULIZER_FORMAT_DATE_DMMDDYYYY_2'),
						FORMAT_DATE_dDDm_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DDDM_1'),
						FORMAT_DATE_dmDD_1 => JText::_('COM_TABULIZER_FORMAT_DATE_DMDD_1'));
		$selected_value = empty($date_format)?FORMAT_DATE_DDMMYY_1:$date_format;				
		$format_date_params_options = $this->getSelectOptions($options, $selected_value);				
						
		$lists['format'] .= '
		<div id="format_params_div">
		
		<span id="format_text_params_div" class="'.$format_text_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td><select name="format_text_params" id="format_text_params">'.$format_text_params_options.'</select></td></tr>' .		
		'</table></div>
		</span>

		<span id="format_numeric_params_div" class="'.$format_numeric_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_NUMERIC_DECIMALS').':</td><td><select name="format_numeric_decimals" id="format_numeric_decimals">'.$numeric_decimals_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_NUMERIC_DEC_POINT'). ':</td><td><select name="format_numeric_dec_point" id="format_numeric_dec_point">'.$numeric_dec_point_options.'</select></td></tr>' . 
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_NUMERIC_THOUSANDS_SEP'). ':</td><td><select name="format_numeric_thousands_sep" id="format_numeric_thousands_sep">'.$numeric_thousands_sep_options.'</select></td></tr>' .
			'</table></div>
		</span>
		
		<span id="format_currency_params_div" class="'.$format_currency_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_DECIMALS').':</td><td><select name="format_currency_decimals" id="format_currency_decimals">'.$currency_decimals_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_DEC_POINT'). ':</td><td><select name="format_currency_dec_point" id="format_currency_dec_point">'.$currency_dec_point_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_THOUSANDS_SEP'). ':</td><td><select name="format_currency_thousands_sep" id="format_currency_thousands_sep">'.$currency_thousands_sep_options.'</select></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL').':</td><td><input type="text" name="format_currency_symbol" id="format_currency_symbol" length="6" maxlength="24" value="'.htmlspecialchars($currency_symbol,ENT_COMPAT,'UTF-8').'"></td></tr>' .
			'<tr class="tr_hi"><td>'.JText::_('COM_TABULIZER_FORMAT_CURRENCY_SYMBOL_ORDER').':</td><td><select name="format_currency_symbol_order" id="format_currency_symbol_order">'.$currency_symbol_order_options.'</select></td></tr>' .
			'</table></div>
		</span>				
		
		<span id="format_date_params_div" class="'.$format_date_params_div_class.'">
		<div class="data_type_params"><br/><br/><table>' .
			'<tr class="tr_hi"><td><select name="format_date_params" id="format_date_params">'.$format_date_params_options.'</select></td></tr>' .		
		'</table></div>
		</span>
		
		</div>';
		
		$lists['format'] .= '<input type="hidden" name="format_data_type_params" id="format_data_type_params" value="'.$data_type_params.'">';							
				
		# replacement
		$replace_cs = 'checked="checked"';
		$replace_from = $replace_to = '';
		if (!empty($rule['replacement'])) {
			list($case_sensitive, $replace_from, $replace_to) = explode(REPLACEMENT_SEPARATOR, $rule['replacement'], 3);
			if ($case_sensitive) $replace_cs = 'checked="cehcked"'; else $replace_cs = '';		
			if (!empty($replace_from)) $replace_from = htmlspecialchars($replace_from,ENT_QUOTES,'UTF-8'); 
			if (!empty($replace_to)) $replace_to = htmlspecialchars($replace_to,ENT_QUOTES,'UTF-8'); 
		}	
		
		$lists['replacement'] = '<span style="float: left; width: auto; margin: 5px 5px 5px 0px;">'. JText::_('COM_TABULIZER_REPLACEMENT_FROM'). '</span><input type="text" name="replace_from" id="replace_from" value="'.$replace_from.'" >' .
								'<span style="float: left; width: auto; margin: 5px 5px 5px 0px;">'.JText::_('COM_TABULIZER_REPLACEMENT_TO'). '</span><input type="text" name="replace_to" id="replace_to" value="'.$replace_to.'" >' .
								'<span style="float: left; width: auto; margin: 5px 5px 5px 0px;">'.JText::_('COM_TABULIZER_REPLACEMENT_CS'). '</span><input type="checkbox" name="replace_cs" id="replace_cs" value="1" '.$replace_cs.' >'; 								
		
		# calculation
		$calculation_value = null;
		if (!empty($rule['calculation'])) {
			$calculation_value = $rule['calculation'];
		}
		
		$options = array(
			CALCULATION_NONE => JText::_('COM_TABULIZER_CALCULATION_NONE'), 
			CALCULATION_ADD_ABOVE => JText::_('COM_TABULIZER_CALCULATION_ADD_ABOVE'), 
			CALCULATION_ADD_BELOW => JText::_('COM_TABULIZER_CALCULATION_ADD_BELOW'), 
			CALCULATION_ADD_LEFT => JText::_('COM_TABULIZER_CALCULATION_ADD_LEFT'), 
			CALCULATION_ADD_RIGHT => JText::_('COM_TABULIZER_CALCULATION_ADD_RIGHT'), 
			CALCULATION_MUL_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MUL_ABOVE'), 
			CALCULATION_MUL_BELOW => JText::_('COM_TABULIZER_CALCULATION_MUL_BELOW'),  
			CALCULATION_MUL_LEFT => JText::_('COM_TABULIZER_CALCULATION_MUL_LEFT'),  
			CALCULATION_MUL_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MUL_RIGHT'), 
			CALCULATION_AVG_ABOVE => JText::_('COM_TABULIZER_CALCULATION_AVG_ABOVE'),  
			CALCULATION_AVG_BELOW => JText::_('COM_TABULIZER_CALCULATION_AVG_BELOW'), 
			CALCULATION_AVG_LEFT => JText::_('COM_TABULIZER_CALCULATION_AVG_LEFT'),  
			CALCULATION_AVG_RIGHT => JText::_('COM_TABULIZER_CALCULATION_AVG_RIGHT'),  
			CALCULATION_MED_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MED_ABOVE'),  
			CALCULATION_MED_BELOW => JText::_('COM_TABULIZER_CALCULATION_MED_BELOW'),  
			CALCULATION_MED_LEFT => JText::_('COM_TABULIZER_CALCULATION_MED_LEFT'),  
			CALCULATION_MED_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MED_RIGHT'),  
			CALCULATION_MIN_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MIN_ABOVE'),  
			CALCULATION_MIN_BELOW => JText::_('COM_TABULIZER_CALCULATION_MIN_BELOW'),  
			CALCULATION_MIN_LEFT => JText::_('COM_TABULIZER_CALCULATION_MIN_LEFT'),  
			CALCULATION_MIN_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MIN_RIGHT'),  
			CALCULATION_MAX_ABOVE => JText::_('COM_TABULIZER_CALCULATION_MAX_ABOVE'), 
			CALCULATION_MAX_BELOW => JText::_('COM_TABULIZER_CALCULATION_MAX_BELOW'),  
			CALCULATION_MAX_LEFT => JText::_('COM_TABULIZER_CALCULATION_MAX_LEFT'),  
			CALCULATION_MAX_RIGHT => JText::_('COM_TABULIZER_CALCULATION_MAX_RIGHT')); 
				
		$selected_value = empty($calculation_value)?CALCULATION_NONE:$calculation_value;				
		$calculation_options = $this->getSelectOptions($options, $selected_value);
				
		$lists['calculation'] = '<select name="calculation" id="calculation">'.$calculation_options.'</select>';
		
		# edit flag
		$lists['edit'] = true;													
		
		$lists['rule_id'] = '<input type="hidden" name="rule_id" value="'.$rule['rule_id'].'" />';
		$lists['ruleset_name'] = '<input type="hidden" name="ruleset_name" value="'.htmlspecialchars($rule['ruleset_name'],ENT_COMPAT,'UTF-8').'" />';
		$lists['filename'] = '<input type="hidden" name="archive_filename" value="'.htmlspecialchars($rule['filename'],ENT_COMPAT,'UTF-8').'" />';
		
		$lists['rule_id_value'] = $rule['rule_id'];
		$lists['ruleset_name_value'] = $rule['ruleset_name']; // $ruleset['name'];
		$lists['filename_value'] = $rule['filename'];
		
		$this->assignRef('lists', $lists);						
		
		parent::display($tpl);
	}	
	
	function getSelectOptions($options, $selected_value) {
		$options_html = '';
		foreach ($options as $value => $label) {
			if ($value == $selected_value) {
				$options_html .= '<option value="'.$value.'" selected="selected">'.$label.'</option>';
			} else {
				$options_html .= '<option value="'.$value.'">'.$label.'</option>';
			}
		}
		return $options_html;
	}
}
?>