﻿<?php
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewruleset&ruleset_name='.urlencode($this->lists['ruleset_name_value']).'&archive_filename='.urlencode($this->lists['filename_value'])));

JHTML::_('behavior.tooltip');
$edit = $this->lists['edit'];
$text = !$edit ? JText::_('COM_TABULIZER_NEW' ) : JText::_('COM_TABULIZER_EDIT' );
JToolBarHelper::title(   JText::_('COM_TABULIZER_RULE' ).': <small><small>[ ' . $text.' ]</small></small>','config' );
JToolBarHelper::save();
if (!$edit)  {
	JToolBarHelper::cancel();
} else {
	// for existing items the button is renamed `close`
	JToolBarHelper::cancel( 'cancel', JText::_('COM_TABULIZER_CLOSE') );
}
JToolBarHelper::help( 'all_topics', true );

$cssfile = JURI::root() . 'administrator/components/com_tabulizer/assets/css/tabulizer.css';
$doc=JFactory::getDocument();
$doc->addStyleSheet($cssfile);

?>


<script language="javascript" type="text/javascript">
	function updateDataType(el) {
		var data_type = el.options[el.selectedIndex].value;
		var span_map = {<?php echo DATA_TYPE_UNDEFINED;?> : null, 
						<?php echo DATA_TYPE_TEXT;?> : 'format_text_params_div', 
						<?php echo DATA_TYPE_NUMERIC;?> : 'format_numeric_params_div', 
						<?php echo DATA_TYPE_CURRENCY;?> : 'format_currency_params_div', 
						<?php echo DATA_TYPE_DATE;?> : 'format_date_params_div' };
						
		var hidden_spans = new Array('format_text_params_div','format_numeric_params_div','format_currency_params_div','format_date_params_div');
		var hidden_span, i;
		for (i=0;i<hidden_spans.length;i++) {
			hidden_span = document.getElementById(hidden_spans[i]);
			hidden_span.className = "hidden_span";
		}
		if (span_map[data_type]) {
			hidden_span = document.getElementById(span_map[data_type]);
			hidden_span.className = "";		
		}				
	}

	function validateElementType(eltype) {
		if ((eltype.value != "row") && (eltype.value != "column") && (eltype.value != "cell")) {
			return false;
		}
		return true;
	}

	function validateElementRange(elrange, eltype) {
		var range = elrange.value.toUpperCase().replace(/\s/g,"");
		var valid = false;
		
		var regex_cells = [/^>([-+]?[0-9]*\.?[0-9]+)$/,/^<([-+]?[0-9]*\.?[0-9]+)$/,/^>=([-+]?[0-9]*\.?[0-9]+)$/,/^<=([-+]?[0-9]*\.?[0-9]+)$/,/^=([-+]?[0-9]*\.?[0-9]+)$/,/^([-+]?[0-9]*\.?[0-9]+)-([-+]?[0-9]*\.?[0-9]+)$/,/^SAMEI(.+)$/i,/^SAMENI(.+)$/i,/^SAMEN(.+)$/i,/^SAME(.+)$/i,/^CONTAINI(.+)$/i,/^CONTAINNI(.+)$/i,/^CONTAINN(.+)$/i,/^CONTAIN(.+)$/i];
		var regex_rowscolumns = [/^([\d]+)$/,/^([\d]+)-([\d]+)$/,/^[0-9]+(,[0-9]+)*$/,/^>([\d]+)$/,/^<([\d]+)$/,/^>=([\d]+)$/,/^<=([\d]+)$/,/^FIRST([\d]+)$/i,/^LAST([\d]+)$/i,/^ODD$/i,/^EVEN$/i,/^MOD([\d]+)$/i];		
		var regex_subrange = [/^([\d]+)-([\d]+)$/,/^>([\d]+)$/,/^<([\d]+)$/,/^>=([\d]+)$/,/^<=([\d]+)$/,/^FIRST([\d]+)$/,/^LAST([\d]+)$/];
		
		var regex, subrange, matches, i;
		
		if (eltype == 'cell') {
			for (i = 0; i < regex_cells.length; i++) {
				regex = regex_cells[i];
				if (regex.test(range)) {					
					valid = true;
					break;
				}
			}
		} else {
			for (i = 0; i < regex_rowscolumns.length; i++) {
				regex = regex_rowscolumns[i];
				if (regex.test(range)) {
					valid = true;
					break;
				}					
			}
			if (!valid) {
				regex = /^MOD([\d]+)\[(.+)\]$/i;
				matches = range.match(regex);
				if (matches) {
					subrange = matches[2];					
					for (var i = 0; i < regex_subrange.length; i++) {
						regex = regex_subrange[i];
						if (regex.test(subrange)) {							
							valid = true;
							break;
						}					
					}										
				}					
			}			
		}												
							
		return valid;
	}
	
	function validateElementRangeCount(elrange_count, eltype) {
		var range_count = elrange_count.value.replace(/\s/g,"");
		var regex = /^([\d]+)$/;
		var valid = true;
		
		if (!regex.test(range_count)) valid = false;
		if (eltype == 'cell') {
			if (range_count != '0') valid = false;
		}
		
		return valid;
	}
	
	function validateElementStyle(elstyle, allow_empty) {
		var style = elstyle.value.replace(/\s/g,"");
		var valid = false;
				
		if (style == "") {
			if (allow_empty) return true;
			else return false;
		}
		
		var regex = /^[0-9a-zA-Z_-]{1,64}$/i;
		if (regex.test(style)) {
			valid = true;
		}	
		
		return valid;
	}
	
	function validateElementAutospan(elautospan, eltype) {
		var valid = true;
		
		if ((elautospan) && (eltype == 'cell')) {
			valid = false;
		}
		
		return valid;
	}
	
	function getTextTypeParams() {
		var text_params = document.getElementById('format_text_params').value;
		return text_params;
	}
	
	function getNumericTypeParams() {
		var numeric_decimals = document.getElementById('format_numeric_decimals').value;
		var numeric_dec_point = document.getElementById('format_numeric_dec_point').value;
		var numeric_thousands_sep = document.getElementById('format_numeric_thousands_sep').value;
		
		var sep = "<?php echo FORMAT_NUMERIC_SEPARATOR; ?>";
		var numeric_params = 	numeric_decimals + sep + numeric_dec_point + sep + numeric_thousands_sep;
		return numeric_params;
	}
	
	function getCurrencyTypeParams() {
		var currency_decimals = document.getElementById('format_currency_decimals').value;
		var currency_dec_point = document.getElementById('format_currency_dec_point').value;
		var currency_thousands_sep = document.getElementById('format_currency_thousands_sep').value;
		var currency_symbol = document.getElementById('format_currency_symbol').value;
		var currency_symbol_order = document.getElementById('format_currency_symbol_order').value;
		
		var sep = "<?php echo FORMAT_CURRENCY_SEPARATOR; ?>";
		var currency_params = 	currency_decimals + sep + currency_dec_point + sep + currency_thousands_sep + sep + currency_symbol + sep + currency_symbol_order;
		return currency_params;
	}
	
	function getDateTypeParams() {
		var date_params = document.getElementById('format_date_params').value;
		return date_params;
	}
	
	function validateElementFormat(eldatatype, eldatatypeparams) {
		var valid = true;
		var typeparams = null;
		
		eldatatype = parseInt(eldatatype);						
		switch (eldatatype) {
			case <?php echo DATA_TYPE_TEXT; ?>: typeparams = getTextTypeParams(); break;
			case <?php echo DATA_TYPE_NUMERIC; ?>: typeparams = getNumericTypeParams(); break;
			case <?php echo DATA_TYPE_CURRENCY; ?>: typeparams = getCurrencyTypeParams(); break;
			case <?php echo DATA_TYPE_DATE; ?>: typeparams = getDateTypeParams(); break;
			default: return true;
		}								
		
		if (!typeparams) {
			valid = false;
		} else {
			eldatatypeparams.value = typeparams;
		}								
		
		return valid;				
	}
	
	function validateElementReplacement(replace_from, replace_to) {
		var valid = true;
		if ((replace_from == '') && (replace_to != '')) valid = false;
		
		return valid;
	}
	
	function validateElementCalculation(elcalculation, eltype, elrange) {
		var valid = true;
		var min_x, min_y,x,y,xy;				
		var acceptable_type = null;					
		
		switch (elcalculation) {
			case "<?php echo CALCULATION_ADD_ABOVE; ?>": min_x =2; min_y=0; acceptable_type = {'cell':"", 'row':""}; break;
			case "<?php echo CALCULATION_ADD_BELOW; ?>": min_x =1; min_y=0; acceptable_type = {'cell':"", 'row':""}; break;
			case "<?php echo CALCULATION_ADD_LEFT; ?>": min_x =0; min_y=1; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_ADD_RIGHT; ?>": min_x =0; min_y=2;acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MUL_ABOVE; ?>": min_x =2; min_y=0; acceptable_type = {'cell':"", 'row':""}; break;
			case "<?php echo CALCULATION_MUL_BELOW; ?>": min_x =1; min_y=0; acceptable_type = {'cell':"", 'row':""}; break;
			case "<?php echo CALCULATION_MUL_LEFT; ?>": min_x =0; min_y=1; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MUL_RIGHT; ?>": min_x =0; min_y=2;acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_AVG_ABOVE; ?>": min_x =2; min_y=0; acceptable_type = {'cell':"", 'row':""}; break;
			case "<?php echo CALCULATION_AVG_BELOW; ?>": min_x =1; min_y=0; acceptable_type = {'cell':"", 'row':""}; ;break;
			case "<?php echo CALCULATION_AVG_LEFT; ?>": min_x =0; min_y=1; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_AVG_RIGHT; ?>": min_x =0; min_y=2; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MED_ABOVE; ?>": min_x =2; min_y=0; acceptable_type = {'cell':"", 'row':""}; break;
			case "<?php echo CALCULATION_MED_BELOW; ?>": min_x =1; min_y=0; acceptable_type = {'cell':"", 'row':""}; break; 
			case "<?php echo CALCULATION_MED_LEFT; ?>": min_x =0; min_y=1; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MED_RIGHT; ?>": min_x =0; min_y=2; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MIN_ABOVE; ?>": min_x =2; min_y=0; acceptable_type = {'cell':"", 'row':""}; break; 
			case "<?php echo CALCULATION_MIN_BELOW; ?>": min_x =1; min_y=0; acceptable_type = {'cell':"", 'row':""}; break; 
			case "<?php echo CALCULATION_MIN_LEFT; ?>": min_x =0; min_y=1; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MIN_RIGHT; ?>": min_x =0; min_y=2; acceptable_type = {'cell':"", 'column':""}; break; 
			case "<?php echo CALCULATION_MAX_ABOVE; ?>": min_x =2; min_y=0; acceptable_type = {'cell':"", 'row':""}; break; 
			case "<?php echo CALCULATION_MAX_BELOW; ?>": min_x =1; min_y=0; acceptable_type = {'cell':"", 'row':""}; break; 
			case "<?php echo CALCULATION_MAX_LEFT; ?>": min_x =0; min_y=1; acceptable_type = {'cell':"", 'column':""}; break; 	
			case "<?php echo CALCULATION_MAX_RIGHT; ?>": min_x =0; min_y=2; acceptable_type = {'cell':"", 'column':""}; break; 		
						
			default: min_x =0; min_y=0; return true; break;
		}
				
		var regex1_a = /^([\d]+)$/;		
		var regex1_b =/^FIRST([\d]+)$/i;
		var regex1_c =/^LAST([\d]+)$/i;
		var regex2_a = /^([\d]+),([\d]+)$/i;			
		var max_int = 100; // max integer value, for our purposes any value > 2
		
		var found_match = false;		
		elrange = elrange.toUpperCase().replace(/\s/g,"");
		
		if ((eltype == 'row') || (eltype == 'column'))  {
			if (!found_match) {
				xy = elrange.match(regex1_a);
				if (xy) {
					found_match = true;
					if (eltype == 'row') {
						x = xy[0];
						y = 1;
					} else if (eltype == 'column') {
						x = 1;
						y = xy[0];
					}
				}
			}
			if (!found_match) {
				xy = elrange.match(regex1_b);
				if (xy) {
					found_match = true;
					if (eltype == 'row') {
						x = xy[0];
						y = 1;
					} else if (eltype == 'column') {
						x = 1;
						y = xy[0];
					}
				}
			}	
			if (!found_match) {
				xy = elrange.match(regex1_c);
				if (xy) {
					found_match = true;
					if (eltype == 'row') {
						x = max_int; 
						y = 1;
					} else if (eltype == 'column') {
						x = 1;
						y = max_int;
					}
				}
			}	
		} else if (eltype == 'cell') {
			 xy = elrange.match(regex2_a);			
			 if (xy) {
				found_match = true;
				x = xy[0];
				y = xy[1]; 
			}	
		}
		
		if (!found_match) return false;		
		else if(eltype in acceptable_type) {
			if ((x < min_x) || (y < min_y))	{
				return false;
			}	
		} else {
			return false;
		} 
		
		return true;				
		
	}		
	
	function validateRuleActionSelected(elstyle, autospan_checked, format_data_type_value, replace_from_value, calculation_value) {
		var selected = false;
		
		if (validateElementStyle(elstyle, false)) selected = true;
		if (autospan_checked) selected = true;
		if (format_data_type_value != 0) selected = true;
		if (replace_from_value != "") selected = true;
		if (calculation_value != 0) selected = true;		
		
		return selected;
	} 

	function validateAndSubmit() {
				
		var form = document.adminForm;	
		var valid = true, error_msg = "";
		
		if (!validateElementType(form.element)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_TYPE');?>";
			alert(form.element.value);
			valid = false;
		}
		
		if (!validateElementRange(form.range, form.element.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_RANGE');?>";
			valid = false;		
		}
		
		if (!validateElementRangeCount(form.range_count, form.element.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_RANGE_COUNT');?>";
			valid = false;		
		}
		
		if (!validateElementStyle(form.style, true)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_STYLE');?>";
			valid = false;			
		}			
		
		if (!validateElementAutospan(form.autospan.checked, form.element.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_AUTOSPAN');?>";
			valid = false;			
		}						
		
		if (!validateElementFormat(form.format_data_type.value, form.format_data_type_params)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_FORMAT');?>";
			valid = false;			
		}						
		
		if (!validateElementReplacement(form.replace_from.value, form.replace_to.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_REPLACEMENT');?>";
			valid = false;			
		}														

		if (!validateElementCalculation(form.calculation.value, form.element.value, form.range.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_ELEMENT_CALCULATION');?>";
			valid = false;			
		}												
		
		if (!validateRuleActionSelected(form.style, form.autospan.checked, form.format_data_type.value, form.replace_from.value, form.calculation.value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_NO_RULE_ACTION_SELECTED');?>";
			valid = false;		
		}
		
		if (valid) {			
			form.submit();
		} else {
			error_msg = "<?php echo JText::_('COM_TABULIZER_JS_ERRORS_FOUND'); ?>" + error_msg;
			alert(error_msg);
		}	
						
	}
	
<?php if(version_compare(JVERSION,'1.6.0','ge')) { ?>		
	
	Joomla.submitbutton = function(pressbutton) {						
		if (pressbutton == 'save') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}		
	}
	
<?php } else { ?>
	
	function submitbutton(pressbutton) {			
		if (pressbutton == 'save') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}		
	}	
	
<?php } ?>									
		
</script>

<form action="index.php" method="post" name="adminForm" id="adminForm">
<div class="col width-60">
	<fieldset class="adminform">
		<legend><?php echo JText::_('COM_TABULIZER_RULE_DETAILS' ); ?></legend>

		<table class="admintable">
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_TYPE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['element']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">				
				<?php echo JText::_('COM_TABULIZER_ELEMENT_RANGE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['range']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_RANGE_COUNT' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['range_count']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_STYLE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['style']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_AUTOSPAN' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['autospan']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_FORMAT' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['format']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_REPLACEMENT' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['replacement']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_ELEMENT_CALCULATION' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['calculation']; ?>
			</td>
		</tr>		
	    </table>
	</fieldset>
</div>

<div class="clr"></div>
	<input type="hidden" name="option" value="com_tabulizer" />
	<?php echo $this->lists['rule_id']; ?>
	<?php echo $this->lists['ruleset_name']; ?>
	<?php echo $this->lists['filename']; ?>		
	<input type="hidden" name="task" value="saveRule" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>

<?php
TabulizerUserMessage::printHelp(JText::_('COM_TABULIZER_FORM_RULE_HELP'));
?>
