<?php
/**
 * @version		2.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright  2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.model' );

class tabulizerModelRulesetarchives extends JModel {
	var $ruleset_archives = null;
	var $css_code = null;
	
	function __construct(){
		parent::__construct();		
	}	
	
	function loadRulesetArchives() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'ruleset.php');
		$ruleset = new Ruleset();		
		$this->ruleset_archives = $ruleset->getRulesets();
		return $this->ruleset_archives;
	}		
	
	function getRulesetArchives() {
		if (empty($this->ruleset_archives)) {
			$this->loadRulesetArchives();
		}
		
		return $this->ruleset_archives;
	}
	
	function getRulesetConflicts() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'ruleset.php');
		$ruleset = new Ruleset();				
		return $ruleset->getRulesetConflicts();				
	}
	
	function exportRulesetArchivesSkeletonCSSCode($export_archive_filenames = array()) {
		if (empty($this->ruleset_archives)) {
			$this->loadRulesetArchives();
		}
		
		if (empty($this->ruleset_archives)) return false;
		else if (empty($export_archive_filenames)) return false;
		
		$css_lines =  array();
		$suffix_sep = '-';
		
		foreach ($this->ruleset_archives as $archive_name => $archive) {
			if (in_array($archive_name, $export_archive_filenames)) {				
				$css_code = '';							
				if (!empty($archive['rulesets'])) {					
					foreach ($archive['rulesets'] as $ruleset) {
						$table_selector = trim('table.tabtable'.$suffix_sep.$ruleset['suffix']);
						$tr_selectors = array('tr.tabrow');
						$td_selectors = array('td.tabcol');
						
						foreach ($ruleset['rules'] as $rule) {
							if ($rule['element'] == 'row') {
								$selector = trim('tr.'.$rule['style']);
								if (!in_array($selector, $tr_selectors)) $tr_selectors[] = $selector;
							} else {
								$selector = trim('td.'.$rule['style']);
								if (!in_array($selector, $td_selectors)) $td_selectors[] = $selector;
							}
						}
												
						foreach ($tr_selectors as $tr_selector) {
							foreach ($td_selectors as $td_selector) {
								$css_line = "{$td_selector} {}\n";
								if (!in_array($css_line, $css_lines)) { $css_code .= $css_line; $css_lines[] = $css_line; }								
								$css_line = "{$tr_selector} {$td_selector} {}\n";
								if (!in_array($css_line, $css_lines)) { $css_code .= $css_line; $css_lines[] = $css_line; }
								$css_line = "{$table_selector} {$tr_selector} {$td_selector} {}\n";
								if (!in_array($css_line, $css_lines)) { $css_code .= $css_line; $css_lines[] = $css_line; }
							}
						}
					}
					if (!empty($css_code)) {
						$this->css_code[$archive_name] = $css_code;
						$css_code = '';
					}	
				}				
			}
		}												
		
		return $this->css_code;
	}
	
	function getRulesetArchivesSkeletonCSSCode() {		
		return $this->css_code;
	}
	
	function isEditorPluginInstalled() {
		$plugin_path = TABULIZER_INCLUDE_PATH;
		if ($handle = opendir($plugin_path)) { 
			return true;
		} else return false;
	}

}
?>