﻿<?php
/**
 * @version		2.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 *
 */
 
// no direct access
defined('_JEXEC') or die('Restricted access');

if (!defined('XML_FILE_EXT')) define('XML_FILE_EXT','.xml');

class Ruleset {

	var $rulesets = null;
	var $conflicts = null;
	var $errors = null;

	/**
	Rulesets
	*/

	function loadRulesets($filename = null, $rulesetname = null) {
		$dir = JPATH_SITE . DS . RULES_XML_DIR;				
		
		if (empty($filename)) {
			# load all xml files in rules folder		
			$xmlfiles = array();
			if (is_dir($dir)) {
				if ($dh = opendir($dir)) {
					while (($file = readdir($dh)) !== false) {
						if (is_file($dir . $file)) {
							if (preg_match('/'.XML_FILE_EXT.'$/',$file)) {
								$xmlfiles[] = $file;
							}
						}
					}	
					closedir($dh);
				}			
			}
		} else {
			# load sepcific xml file
			if (!preg_match('/'.XML_FILE_EXT.'$/',$filename)) {
				$filename .= XML_FILE_EXT;
			}
			if (file_exists($dir . $filename)) {
				$xmlfiles[] = $filename;
			}
		}
		
		# traverse files			
		if (!empty($xmlfiles)) {
			foreach ($xmlfiles as $xmlfile) {
				$contents = file_get_contents($dir . $xmlfile);
				$p = xml_parser_create();
				xml_parse_into_struct($p, $contents, $vals, $index);
				xml_parser_free($p);
				
				$ruleset = array();
				$xmlfile_noext = pathinfo($xmlfile, PATHINFO_FILENAME);			
				$ruleset_name = $xmlfile_noext;	
				$ruleset_title = $xmlfile_noext;				
				$ruleset_filename = $xmlfile;
				
				# init vars
				$rules_name = $rules_title = $rules_style = '';
				$ruleset_name = $ruleset_title = $ruleset_description = $ruleset_style = $ruleset_suffix = '';
				$ruleset_preselected = 0;
				$ruleset_sample_data_text = $ruleset_sample_data_sep = $ruleset_sample_data_enc = '';
				$rule_element = $rule_range = $rule_style = '';								
				$rulesets = array();
				$ruleset = array();
				
				$used = array('rulesets' => array('names' => array(), 'titles' => array()));				
										
				foreach ($vals as $node) {
					switch ($node['tag']) {						
						case 'RULES':
							if ($node['type'] == 'open') {					
								if (!empty($node['attributes']['NAME'])) $rules_name = trim($node['attributes']['NAME']);
								if (!empty($node['attributes']['TITLE'])) $rules_title = trim($node['attributes']['TITLE']);
								if (!empty($node['attributes']['STYLE'])) $rules_style = trim($node['attributes']['STYLE']);
							} else if ($node['type'] == 'close') {
								$ruleset_archive = array('name'=>$rules_name, 'title'=>$rules_title, 'style'=>$rules_style, 'rulesets'=>$rulesets);
								$this->decodeXMLSafe($ruleset_archive);
								$this->rulesets[$xmlfile_noext] = $ruleset_archive;
								$rules_name = $rules_title = $rules_style = '';
								$rulesets = array();								
							} else if ($node['type'] == 'complete') {
								if (!empty($node['attributes']['NAME'])) $rules_name = trim($node['attributes']['NAME']);
								if (!empty($node['attributes']['TITLE'])) $rules_title = trim($node['attributes']['TITLE']);
								if (!empty($node['attributes']['STYLE'])) $rules_style = trim($node['attributes']['STYLE']);
								$ruleset_archive = array('name'=>$rules_name, 'title'=>$rules_title, 'style'=>$rules_style, 'rulesets'=>$rulesets);
								$this->decodeXMLSafe($ruleset_archive);
								$this->rulesets[$xmlfile_noext] = $ruleset_archive;
								$rules_name = $rules_title = $rules_style = '';
								$rulesets = array();								
							}				
							break;
							
						case 'RULESET':
							if ($node['type'] == 'open') {					
								if (!empty($node['attributes']['NAME'])) $ruleset_name = trim($node['attributes']['NAME']);
								if (!empty($node['attributes']['TITLE'])) $ruleset_title = trim($node['attributes']['TITLE']);
								if (!empty($node['attributes']['DESCRIPTION'])) $ruleset_description = trim($node['attributes']['DESCRIPTION']);
								if (!empty($node['attributes']['STYLE'])) $ruleset_style = trim($node['attributes']['STYLE']);
								if (!empty($node['attributes']['SUFFIX'])) $ruleset_suffix = trim($node['attributes']['SUFFIX']);
								if (!empty($node['attributes']['PRESELECTED'])) $ruleset_preselected = 1;
								if (!empty($node['attributes']['SAMPLE_DATA_TEXT']) && !empty($node['attributes']['SAMPLE_DATA_SEP'])) {
									$ruleset_sample_data_text = trim(str_replace(SEPARATOR_NEWLLINE,"\n",$node['attributes']['SAMPLE_DATA_TEXT']));
									$ruleset_sample_data_sep = trim($node['attributes']['SAMPLE_DATA_SEP']);
									$ruleset_sample_data_enc = empty($node['attributes']['SAMPLE_DATA_ENC'])?'':trim($node['attributes']['SAMPLE_DATA_ENC']);
								}																																									
							} else if (($node['type'] == 'close')) {
								if (empty($rulesetname) || ($rulesetname == $ruleset_name)) {
									// check for duplicates names
									if (isset($used['rulesets']['names'][$ruleset_name])) {
										if (empty($this->conflicts['rulesets'])) $this->conflicts['rulesets'] = array('names' => array(), 'titles' => array());
										if (empty($this->conflicts['rulesets']['names'][$xmlfile_noext])) $this->conflicts['rulesets']['names'][$xmlfile_noext] = array();
										$this->conflicts['rulesets']['names'][$xmlfile_noext][] = array('value' => $ruleset_name, 'already_defined' => $used['rulesets']['names'][$ruleset_name]);
									} else {
										$rulesets[$ruleset_name] = array('name'=> $ruleset_name, 'title'=>$ruleset_title, 'description'=>$ruleset_description, 'style'=>$ruleset_style, 'style_inherited'=>$rules_style, 'preselected'=>$ruleset_preselected, 'suffix'=>$ruleset_suffix, 'rules'=>$ruleset);
										if (!empty($ruleset_sample_data_text) && !empty($ruleset_sample_data_sep)) { $rulesets[$ruleset_name]['sample_data'] = 1; $rulesets[$ruleset_name]['sample_data_text'] = $ruleset_sample_data_text; $rulesets[$ruleset_name]['sample_data_sep'] = $ruleset_sample_data_sep; $rulesets[$ruleset_name]['sample_data_enc'] = $ruleset_sample_data_enc; }
										$used['rulesets']['names'][$ruleset_name] = $xmlfile_noext;																														
									}	
									// check for duplicates titles									
									if (isset($used['rulesets']['titles'][$ruleset_title])) {							
										$resolve_duplicate_titles = true;
										if ($resolve_duplicate_titles) {
											$rulesets[$ruleset_name]['title'] = $rulesets[$ruleset_name]['title'] . ' ('.$ruleset_name.')';
										} else {																					
											if (empty($this->conflicts['rulesets'])) $this->conflicts['rulesets'] = array('names' => array(), 'titles' => array());
											if (empty($this->conflicts['rulesets']['titles'][$xmlfile_noext])) $this->conflicts['rulesets']['titles'][$xmlfile_noext] = array();
											$this->conflicts['rulesets']['titles'][$xmlfile_noext][] = array('value' => $ruleset_title, 'already_defined' => $used['rulesets']['titles'][$ruleset_title]);
										}
									} else {
										$used['rulesets']['titles'][$ruleset_title] = $xmlfile_noext;
									}
								}	
								$ruleset_name = $ruleset_title = $ruleset_description = $ruleset_style =  $ruleset_suffix = '';
								$ruleset_sample_data_text = $ruleset_sample_data_sep = $ruleset_sample_data_enc = '';							
								$ruleset_preselected = 0;
								$ruleset = array();
							} else if ($node['type'] == 'complete') {					
								if (!empty($node['attributes']['NAME'])) $ruleset_name = trim($node['attributes']['NAME']);
								if (!empty($node['attributes']['TITLE'])) $ruleset_title = trim($node['attributes']['TITLE']);
								if (!empty($node['attributes']['DESCRIPTION'])) $ruleset_description = trim($node['attributes']['DESCRIPTION']);
								if (!empty($node['attributes']['STYLE'])) $ruleset_style = trim($node['attributes']['STYLE']);
								if (!empty($node['attributes']['SUFFIX'])) $ruleset_suffix = trim($node['attributes']['SUFFIX']);
								if (!empty($node['attributes']['PRESELECTED'])) $ruleset_preselected = 1;								
								//if (!empty($node['attributes']['SAMPLE_DATA_TEXT'])) $ruleset_sample_data_text = trim($node['attributes']['SAMPLE_DATA_TEXT']);
								//if (!empty($node['attributes']['SAMPLE_DATA_SEP'])) $ruleset_sample_data_sep = trim($node['attributes']['SAMPLE_DATA_SEP']);									
								
								if (empty($rulesetname) || ($rulesetname == $ruleset_name)) {																																
									// check for duplicates names
									if (isset($used['rulesets']['names'][$ruleset_name])) {																			
										if (empty($this->conflicts['rulesets'])) $this->conflicts['rulesets'] = array('names' => array(), 'titles' => array());
										if (empty($this->conflicts['rulesets']['names'][$xmlfile_noext])) $this->conflicts['rulesets']['names'][$xmlfile_noext] = array();
										$this->conflicts['rulesets']['names'][$xmlfile_noext][] = array('value' => $ruleset_name, 'already_defined' => $used['rulesets']['names'][$ruleset_name]);
									} else {
										$rulesets[$ruleset_name] = array('name'=> $ruleset_name, 'title'=>$ruleset_title, 'description'=>$ruleset_description, 'style'=>$ruleset_style, 'style_inherited'=>$rules_style, 'preselected'=>$ruleset_preselected, 'suffix'=>$ruleset_suffix, 'rules'=>$ruleset);
										if (!empty($ruleset_sample_data_text)) { $rulesets[$ruleset_name]['sample_data'] = 1; $rulesets[$ruleset_name]['sample_data_text'] = $ruleset_sample_data_text; $rulesets[$ruleset_name]['sample_data_sep'] = $ruleset_sample_data_sep; $rulesets[$ruleset_name]['sample_data_enc'] = $ruleset_sample_data_enc; }
										$used['rulesets']['names'][$ruleset_name] = $xmlfile_noext;										
									}	
									// check for duplicates titles									
									if (isset($used['rulesets']['titles'][$ruleset_title])) {									
										if (empty($this->conflicts['rulesets'])) $this->conflicts['rulesets'] = array('names' => array(), 'titles' => array());
										if (empty($this->conflicts['rulesets']['titles'][$xmlfile_noext])) $this->conflicts['rulesets']['titles'][$xmlfile_noext] = array();
										$this->conflicts['rulesets']['titles'][$xmlfile_noext][] = array('value' => $ruleset_title, 'already_defined' => $used['rulesets']['titles'][$ruleset_title]);																														
									} else {
										$used['rulesets']['titles'][$ruleset_title] = $xmlfile_noext;
									}									
								}	
								$ruleset_name = $ruleset_title = $ruleset_description = $ruleset_style = $ruleset_suffix = '';
								$ruleset_sample_data_text = $ruleset_sample_data_sep = $ruleset_sample_data_enc = '';
								$ruleset_preselected = 0;
								$ruleset = array();
							}
							break;
							
						case 'RULE':
							if ($node['type'] == 'complete') {															
								$attributes = $node['attributes'];
								$rule_element = $rule_range = $rule_range_count = $rule_style = $rule_autospan = $rule_format = $rule_replacement = $rule_calculation = '';
								if (!empty($attributes['ELEMENT'])) $rule_element = trim($attributes['ELEMENT']);
								if (!empty($attributes['RANGE'])) $rule_range = trim($attributes['RANGE']);
								if (!empty($attributes['RANGE_COUNT'])) $rule_range_count = trim($attributes['RANGE_COUNT']);
								
								$rule_range = trim($rule_range);
								if (preg_match('/^SAME(.+)/i',$rule_range) || preg_match('/^CONTAIN(.+)/i',$rule_range)) {
									// leave it as it is, do not uppercase or remove spaces
								} else {								
									$rule_range = strtoupper(str_replace(' ','', trim($rule_range)));				
								}	
								# <> are not allowed in the XML files, so replace them with LT and GT
								$gl_values = array('LTE','LT','GTE','GT');
								$sy_values = array('<=','<','>=','>');									
								$rule_range = str_replace($gl_values, $sy_values, $rule_range);
																
								if (!empty($attributes['STYLE'])) $rule_style = trim($attributes['STYLE']);
								if (!empty($attributes['AUTOSPAN'])) $rule_autospan = trim($attributes['AUTOSPAN']);
								if (!empty($attributes['FORMAT'])) $rule_format = trim($attributes['FORMAT']);
								if (!empty($attributes['CALCULATION'])) $rule_calculation = trim($attributes['CALCULATION']);
								if (!empty($attributes['REPLACEMENT'])) $rule_replacement = trim($attributes['REPLACEMENT']);
								
								$ruleset[] = array('element'=>$rule_element, 'range'=>$rule_range, 'range_count'=>$rule_range_count, 'style'=>$rule_style, 'autospan'=>$rule_autospan, 'format'=>$rule_format, 'replacement'=>$rule_replacement, 'calculation'=>$rule_calculation);
							}
							break;
							
						case 'SAMPLE_DATA':
							if ($node['type'] == 'complete') {					
								if (!empty($node['attributes']['SEP'])) $ruleset_sample_data_sep = trim($node['attributes']['SEP']);
								if (!empty($node['attributes']['ENC'])) $ruleset_sample_data_enc = trim($node['attributes']['ENC']);
								$ruleset_sample_data_text = trim($node['value']);								
							}	
							break;										
							
						default:
							$this->errors[] = sprintf(JText::_('INVALID XML TAG'), $node['tag']);	
							break;
	
					}
				}								
				
				if (!empty($ruleset)) {
					if (empty($this->rulesets)) $this->rulesets = array();										
					$this->rulesets[$ruleset_name] = array('name' => $ruleset_name, 'title' => $ruleset_title, 'filename' => $ruleset_filename, 'rules' => array_unique($ruleset));
				}												
								
			}
		} else {
			$errors[] = JText::_('NO VALID RULESET ARCHIVES');
		}				
				
	}
	
	function getRulesets($filename = null) {
		if (empty($this->rulesets)) {
			$this->loadRulesets(/*$filename*/);
		}

		if (empty($this->rulesets)) {
			return null;
		} else if (empty($filename)) {
			return $this->rulesets;	
		} else {
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {
				if ($archive_name == $filename) {
					return $ruleset_archive;
				}
			}
		}				
		
		return null;
	}
	
	function getAllRulesetArchiveFilenames($exclude_archive_filenames = array()) {
		$archive_filenames = array();
		$rulesets = $this->getRulesets();			
		
		$found = false;				
		if (!empty($rulesets)) {			
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {							
				if (!in_array($archive_name, $exclude_archive_filenames))
				$archive_filenames[] = $archive_name.XML_FILE_EXT;
			}					
		}		
		
		return $archive_filenames;
	}		
	
	function getAllRulesetArchiveNames($exclude_archive_names = array()) {
		$archive_names = array();
		$rulesets = $this->getRulesets();			
		
		$found = false;				
		if (!empty($rulesets)) {			
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {				
				if (!in_array($ruleset_archive['name'], $exclude_archive_names))
				$archive_names[] = $ruleset_archive['name'];
			}					
		}		
		
		return $archive_names;
	}	
	
	function getAllRulesetArchiveTitles($exclude_archive_titles = array()) {
		$archive_titles = array();
		$rulesets = $this->getRulesets();			
		
		$found = false;				
		if (!empty($rulesets)) {			
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {				
				if (!in_array($ruleset_archive['title'], $exclude_archive_titles))
				$archive_titles[] = htmlspecialchars($ruleset_archive['title'],ENT_COMPAT,'UTF-8');
			}					
		}		
		
		return $archive_titles;
	}		
	
	function getAllRulesetNames($exclude_ruleset_names = array(), $filename = null) {
		$ruleset_names = array();
		$rulesets = $this->getRulesets($filename);			
		
		$found = false;				
		if (!empty($rulesets)) {			
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {
				if (!empty($filename) && ($archive_name != $filename)) continue;								
				foreach ($ruleset_archive['rulesets'] as $ruleset_name => $ruleset) {
					if (!in_array($ruleset_name, $exclude_ruleset_names))
						$ruleset_names[] = $ruleset_name;
				}				
			}					
		}		
		
		return $ruleset_names;
	}
	
	function getRecommendedName($seed = null, $filename = null) {
		$max_id = 1024;
		$recommended_ruleset_name = '';		
		$all_ruleset_names = $this->getAllRulesetNames();
		for ($i=1;$i<$max_id;$i++) {
			$recommended_ruleset_name = 'ruleset_'.$i;
			if (!in_array($recommended_ruleset_name, $all_ruleset_names)) {
				return $recommended_ruleset_name;
			}
		}		
		return '';
	}
	
	function getAllRulesetTitles($exclude_ruleset_titles = array(), $filename = null) {
		$ruleset_names = array();
		$rulesets = $this->getRulesets($filename);			
		
		$found = false;				
		if (!empty($rulesets)) {			
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {
				if (!empty($filename) && ($archive_name != $filename)) continue;								
				foreach ($ruleset_archive['rulesets'] as $ruleset_name => $ruleset) {
					if (!in_array($ruleset['title'], $exclude_ruleset_titles))
						$ruleset_titles[] = htmlspecialchars($ruleset['title'],ENT_COMPAT,'UTF-8');
				}				
			}					
		}		
		
		return $ruleset_titles;
	}

	
	function getRulesetConflicts() {
		if (empty($this->rulesets)) {
			$this->loadRulesets();
		}				
		
		return $this->conflicts;	
	}		
	
	function _saveRulesetArchive($ruleset_archive, $archive_name) {
		$dir = JPATH_SITE . DS . RULES_XML_DIR;
		$filename = $dir . $archive_name . XML_FILE_EXT;						
		
		// make values safe to store in XML file
		$this->encodeXMLSafe($ruleset_archive);
		
		$contents = '<?xml version="1.0" encoding="utf-8"?>
<rules name="'.$ruleset_archive['name'].'" title="'.$ruleset_archive['title'].'" style="'.$ruleset_archive['style'].'">' . "\n";

		$rulesets = &$ruleset_archive['rulesets'];
		foreach ($rulesets as $ruleset) {										
			// make values safe to store in XML file
			$this->encodeXMLSafe($ruleset);
			
			$extra_ruleset_attr = '';
		
			// style/CSS
			if (!empty($ruleset['style'])) $extra_ruleset_attr .= ' style="'.$ruleset['style'].'"';
            //  preselected
			if (!empty($ruleset['preselected'])) $extra_ruleset_attr .= ' preselected="1"';
			// sample data
			if (!empty($ruleset['sample_data'])) { 
				# important note: XML file has problems storing multiline
				$sample_data_attr = '';
				if (!empty($ruleset['sample_data_sep'])) $sample_data_attr .= ' sep="'.$ruleset['sample_data_sep'].'"';
				if (!empty($ruleset['sample_data_enc'])) $sample_data_attr .= ' enc="'.$ruleset['sample_data_enc'].'"';
				$sample_data = '  <sample_data '.$sample_data_attr.'>'.$ruleset['sample_data_text'].'</sample_data>' . "\n"; 
			} else { 
				$sample_data = ''; 
			}									
			
			$ruleset_block = '<ruleset name="'.$ruleset['name'].'" title="'.$ruleset['title'].'" description="'.$ruleset['description'].'" suffix="'.$ruleset['suffix'].'" '.$extra_ruleset_attr.' >' . "\n";
			if (!empty($sample_data)) $ruleset_block .= $sample_data;
			$rules = &$ruleset['rules'];								
			foreach ($rules as $rule) {
				$this->sanitizeRule($rule);
				$rule_attribues = '';			
				// make values safe to store in XML file
				$this->encodeXMLSafe($rule);													
				foreach ($rule as $key => $value) {					
					$rule_attribues .= $key . '="'.$value.'" '; 
				}
				$ruleset_block .= '  <rule '.$rule_attribues.'></rule>' . "\n";
			}
			$ruleset_block .= '</ruleset>' . "\n";
			$contents .= $ruleset_block;
		}

		$contents .= '</rules>';							
		
		if (file_exists($filename)) {
			// show warning?
		}				
		
		$bytes_written = file_put_contents($filename, $contents);		
		if (!$bytes_written) {
			$msg = sprintf(JText::_('COM_TABULIZER_WRONG_RULESET_FILE_PERMISSIONS'),$filename);
			JError::raiseWarning( 101, $msg );
		}
		
		return $bytes_written;
	}
	
	function saveRulesetArchive($new_ruleset_archive, $filename) {
		if (empty($this->rulesets)) {
			$this->loadRulesets(/*$new_ruleset['filename']*/);						
		}					
		
		# copy rulesets from the orifginal archive, if any
		$new_ruleset_archive['rulesets'] = array();		
		foreach ($this->rulesets as $archive_name => $ruleset_archive) {
			if ($archive_name != $filename) continue;																	
			if (!empty($ruleset_archive['rulesets']))
				$new_ruleset_archive['rulesets'] = $ruleset_archive['rulesets'];			
		}		
	
		return $this->_saveRulesetArchive($new_ruleset_archive, $filename);	
	}
	
	function _deleteRulesetArchive($filenames) {
		$dir = JPATH_SITE . DS . RULES_XML_DIR;
	
		if (empty($filenames)) return false;
		foreach ($filenames as $filename) {
			$filename = $dir . $filename . XML_FILE_EXT;					
			if (file_exists($filename)) {
				if (!unlink($filename)) return false;
			} else return false;
		}
		
		return true;
	}
	
	function deleteRulesetArchive($filenames) {
		return $this->_deleteRulesetArchive($filenames);			
	}
	
	/**
	Ruleset
	*/
	
	function getRuleset($ruleset_name, $filename = null) {
		if (empty($this->rulesets)) {
			$this->loadRulesets(/*$filename*/);
		}
		
		if (empty($this->rulesets)) {
			return null;
		} else {									
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {
				if (!empty($filename) && ($archive_name != $filename)) continue;								
				foreach ($ruleset_archive['rulesets'] as $ruleset) {
					if ($ruleset['name'] == $ruleset_name) {
						$ruleset['filename'] = $archive_name;
						return $ruleset;
					}				
				}		
			}
		}
		
		return null;
	}
	
	function _saveRuleset($new_ruleset) {						
	
		if (empty($this->rulesets)) {
			$this->loadRulesets(/*$new_ruleset['filename']*/);
		}									
		
		if (isset($this->rulesets)) {
			$found = false;
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {
				if (!empty($new_ruleset['filename']) && ($archive_name != $new_ruleset['filename'])) continue;																	
				foreach ($ruleset_archive['rulesets'] as &$ruleset) {
					if ($ruleset['name'] == $new_ruleset['name']) {					
						$ruleset['name'] = (isset($new_ruleset['name']))?$new_ruleset['name']:'';
						$ruleset['title'] = (isset($new_ruleset['title']))?$new_ruleset['title']:'';
						$ruleset['description'] = (isset($new_ruleset['description']))?$new_ruleset['description']:'';
						$ruleset['style'] = (isset($new_ruleset['style']))?$new_ruleset['style']:'';
						$ruleset['suffix'] = (isset($new_ruleset['suffix']))?$new_ruleset['suffix']:'';
						$ruleset['preselected'] = (isset($new_ruleset['preselected']))?$new_ruleset['preselected']:null;		
						if (!empty($new_ruleset['sample_data'])) {
							$ruleset['sample_data'] = 1;
							$ruleset['sample_data_text'] = $new_ruleset['sample_data_text'];					
							$ruleset['sample_data_sep'] = $new_ruleset['sample_data_sep'];
							$ruleset['sample_data_enc'] = empty($new_ruleset['sample_data_enc'])?'':$new_ruleset['sample_data_enc'];
						} else {
							$ruleset['sample_data'] = null;
						}
						if (isset($new_ruleset['rules'])) $ruleset['rules'] = $new_ruleset['rules'];							
																																						
						return $this->_saveRulesetArchive($ruleset_archive, $archive_name);			
					}				
				}
				// add new ruleset
				$ruleset_archive['rulesets'][] = $new_ruleset;
				return $this->_saveRulesetArchive($ruleset_archive, $archive_name);					
			}			
		}		
		
		return false;		
	}
	
	function saveRuleset($ruleset, $ruleset_file) {
		return $this->_saveRuleset($ruleset);		
	}	
	
	function _deleteRuleset($ruleset_names, $filename) {
		$rulesets = $this->getRulesets($filename);	
		
		$found = false;				
		if (!empty($rulesets)) {			
			foreach ($this->rulesets as $archive_name => $ruleset_archive) {
				if (!empty($filename) && ($archive_name != $filename)) continue;								
				foreach ($ruleset_archive['rulesets'] as $ruleset_name => $ruleset) {
					if (in_array($ruleset['name'],$ruleset_names)) {											
						unset($ruleset_archive['rulesets'][$ruleset_name]);		
						$found = true;
					}				
				}
				if ($found) return $this->_saveRulesetArchive($ruleset_archive, $archive_name);
			}					
		}		
				
		return false;			
	}
	
	function deleteRuleset($ruleset_names, $ruleset_file) {			
		return $this->_deleteRuleset($ruleset_names, $ruleset_file);
	}
	
	/**
	Rule
	*/
	
	function getRule($rule_id, $ruleset_name, $filename = null) {
		$ruleset = $this->getRuleset($ruleset_name, $filename);
		
		if (!empty($ruleset)) {
			foreach ($ruleset['rules'] as $id => $rule) {
				if ($id == $rule_id) {
					return $rule;
				}
			}
		}
				
		return null;
	}
	
	function _saveRule($new_rule, $rule_id, $ruleset_name, $filename = null) {			
		$ruleset = $this->getRuleset($ruleset_name, $filename);														
		if (!empty($ruleset)) {
			if ($rule_id >= count($ruleset['rules'])) {
				$ruleset['rules'][] = $new_rule;																
				return $this->_saveRuleset($ruleset);
			} else {
				foreach ($ruleset['rules'] as $id => $rule) {
					if ($id == $rule_id) {
						$ruleset['rules'][$id] = $new_rule;															
						return $this->_saveRuleset($ruleset);
					}
				}
			}
		}
				
		return false;
	}
	
	function saveRule($rule, $rule_id, $ruleset_name, $filename = null) {	
		return $this->_saveRule($rule, $rule_id, $ruleset_name, $filename);	
	}
	
	function _deleteRule($rule_ids, $ruleset_name, $filename) {
		$ruleset = $this->getRuleset($ruleset_name, $filename);		
						
		rsort($rule_ids, SORT_NUMERIC);
		
		$found = false;				
		if (!empty($ruleset)) {			
			foreach ($rule_ids as $rule_id) {
				if (isset($ruleset['rules'][$rule_id])) {
					unset($ruleset['rules'][$rule_id]);					
					$found = true;
				}
			}
		}		
		
		if ($found) {
			return $this->_saveRuleset($ruleset);
		} else return false;	
				
	}
	
	function deleteRule($rule_ids, $ruleset_name, $filename = null) {
		return $this->_deleteRule($rule_ids, $ruleset_name, $filename);	
	}
	
	/**
	General
	*/
	
	function sanitizeRule(&$rule) {
			
		# take special care of < > symbols that cannot be stored as values in an XML file
		$rule_range = trim($rule['range']);		
		if (preg_match('/^SAME(.+)/i',$rule_range) || preg_match('/^CONTAIN(.+)/i',$rule_range)) {
			// leave it as it is, do not uppercase or remove spaces
		} else {								
			$rule_range = strtoupper(str_replace(' ','', trim($rule_range)));			
		}							
		$gl_values = array('LTE','LT','GTE','GT');
		$sy_values = array('<=','<','>=','>');			
		$rule['range'] = str_replace($sy_values, $gl_values, $rule_range);		
		
		# remove empty/null attributes
		$rule_attributes = array('element' =>1, 'range'=>1, 'style'=>0, 'autospan'=>0, 'format'=>0, 'replacement'=>0, 'calculation'=>0);
		foreach ($rule_attributes as $key=>$required) {
			if (empty($rule[$key])) unset($rule[$key]);
		}				
	}
	
	function encodeXMLSafe(&$values, $recursive = false) {	
		if (is_array($values)) {
			foreach ($values as $key=> &$value) { 
				if (!empty($value)) {
					if (is_array($value)) {
						if ($recursive) {
							$this->encodeXMLSafe($value);
						}
					} else {
						$value = htmlspecialchars($value,ENT_QUOTES,'UTF-8'); 
					}
				}	
			}
		} else {
			if (!empty($values)) {
				$values = htmlspecialchars($values,ENT_QUOTES,'UTF-8'); 
			}
		}			
	}		
	
	function decodeXMLSafe(&$values) {			
		if (is_array($values)) {
			foreach ($values as $key=> &$value) { 
				if (!empty($value)) {
					if (is_array($value)) {
						$this->decodeXMLSafe($value);
					} else {
						$value = htmlspecialchars_decode($value,ENT_QUOTES); 
					}
				}	
			}
		} else {
			if (!empty($values)) {
				$values = htmlspecialchars_decode($values,ENT_QUOTES); 
			}
		}					
	}
	
	function getErrors() {
		return $this->errors;
	}
	
}

?>