<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

class TabulizerPermissions {
	
	function getUserId() {
		$user =&JFactory::getUser();		
		if (!$user->guest) {
			$user_id = $user->id;
		} else {
			$user_id = 0;
		}
		
		return $user_id;
	}

	function isAllowed($action, $user_id = null) {
		if (empty($user_id)) $user_id = $this->getUserId(); else $user_id = 0;
						
		switch ($action) {
			case 'ruleset-use':
			case 'ruleset-edit':
			case 'ruleset-import':
			case 'excel-import':
				$parameter_name = 'tabulizer-'.$action;				
				$query = null;
				if(version_compare(JVERSION,'1.6.0','ge')) {
					$tabulizer_plugin = JPluginHelper::getPlugin('editors-xtd', 'tabulizer');
					$tabulizerPluginParams = new JRegistry();
					$tabulizerPluginParams->loadString($tabulizer_plugin->params);
					$group_selection = $tabulizerPluginParams->get($parameter_name, ''); 								
					if (!empty($group_selection)) $group_ids = (is_array($group_selection))?$group_selection:array($group_selection); else $group_ids = array();
					if (count($group_ids)) $query = 'SELECT count(*) FROM `#__user_usergroup_map` WHERE `user_id` = '.$user_id.' AND `group_id` IN ('.implode(',',$group_ids).');';
				} else {
					$tabulizer_plugin = &JPluginHelper::getPlugin('editors-xtd', 'tabulizer');
					$tabulizerPluginParams = new JParameter($tabulizer_plugin->params);
					$group_selection = $tabulizerPluginParams->get($parameter_name, ''); 				
					if (!empty($group_selection)) $group_ids = (is_array($group_selection))?$group_selection:array($group_selection); else $group_ids = array();
					if (count($group_ids)) $query = 'SELECT count(*) FROM `#__users` WHERE `id` = '.$user_id.' AND `gid` IN ('.implode(',',$group_ids).');';																				
				}	
				if (!empty($query)) {				
					$database = &JFactory::getDBO();
					$database->setQuery($query);
					$result = $database->loadResult();
				} else $result = false;
				if ($result) return true; else return false;				
				
				break;
			default:
				return false;	
		}
	}
}


?>